@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.CustomEntityStoreAssignmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Custom entity store assignment
 * Azure REST API version: 2021-07-01-preview. Prior API version in Azure Native 1.x: 2021-07-01-preview.
 * ## Example Usage
 * ### Create a custom entity store assignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customEntityStoreAssignment = new AzureNative.Security.CustomEntityStoreAssignment("customEntityStoreAssignment", new()
 *     {
 *         CustomEntityStoreAssignmentName = "33e7cc6e-a139-4723-a0e5-76993aee0771",
 *         Principal = "aaduser=f3923a3e-ad57-4752-b1a9-fbf3c8e5e082;72f988bf-86f1-41af-91ab-2d7cd011db47",
 *         ResourceGroupName = "TestResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewCustomEntityStoreAssignment(ctx, "customEntityStoreAssignment", &security.CustomEntityStoreAssignmentArgs{
 * 			CustomEntityStoreAssignmentName: pulumi.String("33e7cc6e-a139-4723-a0e5-76993aee0771"),
 * 			Principal:                       pulumi.String("aaduser=f3923a3e-ad57-4752-b1a9-fbf3c8e5e082;72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 			ResourceGroupName:               pulumi.String("TestResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.CustomEntityStoreAssignment;
 * import com.pulumi.azurenative.security.CustomEntityStoreAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customEntityStoreAssignment = new CustomEntityStoreAssignment("customEntityStoreAssignment", CustomEntityStoreAssignmentArgs.builder()
 *             .customEntityStoreAssignmentName("33e7cc6e-a139-4723-a0e5-76993aee0771")
 *             .principal("aaduser=f3923a3e-ad57-4752-b1a9-fbf3c8e5e082;72f988bf-86f1-41af-91ab-2d7cd011db47")
 *             .resourceGroupName("TestResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:CustomEntityStoreAssignment 33e7cc6e-a139-4723-a0e5-76993aee0771 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Security/customEntityStoreAssignments/{customEntityStoreAssignmentName}
 * ```
 * @property customEntityStoreAssignmentName Name of the custom entity store assignment. Generated name is GUID.
 * @property principal The principal assigned with entity store. If not provided, will use caller principal. Format of principal is: [AAD type]=[PrincipalObjectId];[TenantId]
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class CustomEntityStoreAssignmentArgs(
    public val customEntityStoreAssignmentName: Output<String>? = null,
    public val principal: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.CustomEntityStoreAssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.security.CustomEntityStoreAssignmentArgs =
        com.pulumi.azurenative.security.CustomEntityStoreAssignmentArgs.builder()
            .customEntityStoreAssignmentName(customEntityStoreAssignmentName?.applyValue({ args0 -> args0 }))
            .principal(principal?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomEntityStoreAssignmentArgs].
 */
@PulumiTagMarker
public class CustomEntityStoreAssignmentArgsBuilder internal constructor() {
    private var customEntityStoreAssignmentName: Output<String>? = null

    private var principal: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Name of the custom entity store assignment. Generated name is GUID.
     */
    @JvmName("rehmeagyeaensvgw")
    public suspend fun customEntityStoreAssignmentName(`value`: Output<String>) {
        this.customEntityStoreAssignmentName = value
    }

    /**
     * @param value The principal assigned with entity store. If not provided, will use caller principal. Format of principal is: [AAD type]=[PrincipalObjectId];[TenantId]
     */
    @JvmName("gabhyywhfdbudoee")
    public suspend fun principal(`value`: Output<String>) {
        this.principal = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("ohoccxxjiodjbjrv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the custom entity store assignment. Generated name is GUID.
     */
    @JvmName("vfiuplqjitppmjhq")
    public suspend fun customEntityStoreAssignmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customEntityStoreAssignmentName = mapped
    }

    /**
     * @param value The principal assigned with entity store. If not provided, will use caller principal. Format of principal is: [AAD type]=[PrincipalObjectId];[TenantId]
     */
    @JvmName("fjsnwnmjnuruvlyf")
    public suspend fun principal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principal = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("rrukqtxmcltfoiqx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): CustomEntityStoreAssignmentArgs = CustomEntityStoreAssignmentArgs(
        customEntityStoreAssignmentName = customEntityStoreAssignmentName,
        principal = principal,
        resourceGroupName = resourceGroupName,
    )
}
