@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.DevOpsConfigurationArgs.builder
import com.pulumi.azurenative.security.kotlin.inputs.DevOpsConfigurationPropertiesArgs
import com.pulumi.azurenative.security.kotlin.inputs.DevOpsConfigurationPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * DevOps Configuration resource.
 * Azure REST API version: 2023-09-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate_DevOpsConfigurations_OnboardCurrentAndFuture
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var devOpsConfiguration = new AzureNative.Security.DevOpsConfiguration("devOpsConfiguration", new()
 *     {
 *         Properties = new AzureNative.Security.Inputs.DevOpsConfigurationPropertiesArgs
 *         {
 *             Authorization = new AzureNative.Security.Inputs.AuthorizationArgs
 *             {
 *                 Code = "00000000000000000000",
 *             },
 *             AutoDiscovery = "Enabled",
 *         },
 *         ResourceGroupName = "myRg",
 *         SecurityConnectorName = "mySecurityConnectorName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewDevOpsConfiguration(ctx, "devOpsConfiguration", &security.DevOpsConfigurationArgs{
 * 			Properties: security.DevOpsConfigurationPropertiesResponse{
 * 				Authorization: &security.AuthorizationArgs{
 * 					Code: pulumi.String("00000000000000000000"),
 * 				},
 * 				AutoDiscovery: pulumi.String("Enabled"),
 * 			},
 * 			ResourceGroupName:     pulumi.String("myRg"),
 * 			SecurityConnectorName: pulumi.String("mySecurityConnectorName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.DevOpsConfiguration;
 * import com.pulumi.azurenative.security.DevOpsConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var devOpsConfiguration = new DevOpsConfiguration("devOpsConfiguration", DevOpsConfigurationArgs.builder()
 *             .properties(Map.ofEntries(
 *                 Map.entry("authorization", Map.of("code", "00000000000000000000")),
 *                 Map.entry("autoDiscovery", "Enabled")
 *             ))
 *             .resourceGroupName("myRg")
 *             .securityConnectorName("mySecurityConnectorName")
 *             .build());
 *     }
 * }
 * ```
 * ### CreateOrUpdate_DevOpsConfigurations_OnboardCurrentOnly
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var devOpsConfiguration = new AzureNative.Security.DevOpsConfiguration("devOpsConfiguration", new()
 *     {
 *         Properties = new AzureNative.Security.Inputs.DevOpsConfigurationPropertiesArgs
 *         {
 *             Authorization = new AzureNative.Security.Inputs.AuthorizationArgs
 *             {
 *                 Code = "00000000000000000000",
 *             },
 *             AutoDiscovery = "Disabled",
 *         },
 *         ResourceGroupName = "myRg",
 *         SecurityConnectorName = "mySecurityConnectorName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewDevOpsConfiguration(ctx, "devOpsConfiguration", &security.DevOpsConfigurationArgs{
 * 			Properties: security.DevOpsConfigurationPropertiesResponse{
 * 				Authorization: &security.AuthorizationArgs{
 * 					Code: pulumi.String("00000000000000000000"),
 * 				},
 * 				AutoDiscovery: pulumi.String("Disabled"),
 * 			},
 * 			ResourceGroupName:     pulumi.String("myRg"),
 * 			SecurityConnectorName: pulumi.String("mySecurityConnectorName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.DevOpsConfiguration;
 * import com.pulumi.azurenative.security.DevOpsConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var devOpsConfiguration = new DevOpsConfiguration("devOpsConfiguration", DevOpsConfigurationArgs.builder()
 *             .properties(Map.ofEntries(
 *                 Map.entry("authorization", Map.of("code", "00000000000000000000")),
 *                 Map.entry("autoDiscovery", "Disabled")
 *             ))
 *             .resourceGroupName("myRg")
 *             .securityConnectorName("mySecurityConnectorName")
 *             .build());
 *     }
 * }
 * ```
 * ### CreateOrUpdate_DevOpsConfigurations_OnboardSelected
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var devOpsConfiguration = new AzureNative.Security.DevOpsConfiguration("devOpsConfiguration", new()
 *     {
 *         Properties = new AzureNative.Security.Inputs.DevOpsConfigurationPropertiesArgs
 *         {
 *             Authorization = new AzureNative.Security.Inputs.AuthorizationArgs
 *             {
 *                 Code = "00000000000000000000",
 *             },
 *             AutoDiscovery = "Disabled",
 *             TopLevelInventoryList = new[]
 *             {
 *                 "org1",
 *                 "org2",
 *             },
 *         },
 *         ResourceGroupName = "myRg",
 *         SecurityConnectorName = "mySecurityConnectorName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewDevOpsConfiguration(ctx, "devOpsConfiguration", &security.DevOpsConfigurationArgs{
 * 			Properties: security.DevOpsConfigurationPropertiesResponse{
 * 				Authorization: &security.AuthorizationArgs{
 * 					Code: pulumi.String("00000000000000000000"),
 * 				},
 * 				AutoDiscovery: pulumi.String("Disabled"),
 * 				TopLevelInventoryList: pulumi.StringArray{
 * 					pulumi.String("org1"),
 * 					pulumi.String("org2"),
 * 				},
 * 			},
 * 			ResourceGroupName:     pulumi.String("myRg"),
 * 			SecurityConnectorName: pulumi.String("mySecurityConnectorName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.DevOpsConfiguration;
 * import com.pulumi.azurenative.security.DevOpsConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var devOpsConfiguration = new DevOpsConfiguration("devOpsConfiguration", DevOpsConfigurationArgs.builder()
 *             .properties(Map.ofEntries(
 *                 Map.entry("authorization", Map.of("code", "00000000000000000000")),
 *                 Map.entry("autoDiscovery", "Disabled"),
 *                 Map.entry("topLevelInventoryList",
 *                     "org1",
 *                     "org2")
 *             ))
 *             .resourceGroupName("myRg")
 *             .securityConnectorName("mySecurityConnectorName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:DevOpsConfiguration default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default
 * ```
 * @property properties DevOps Configuration properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property securityConnectorName The security connector name.
 */
public data class DevOpsConfigurationArgs(
    public val properties: Output<DevOpsConfigurationPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val securityConnectorName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.DevOpsConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.security.DevOpsConfigurationArgs =
        com.pulumi.azurenative.security.DevOpsConfigurationArgs.builder()
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .securityConnectorName(securityConnectorName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DevOpsConfigurationArgs].
 */
@PulumiTagMarker
public class DevOpsConfigurationArgsBuilder internal constructor() {
    private var properties: Output<DevOpsConfigurationPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var securityConnectorName: Output<String>? = null

    /**
     * @param value DevOps Configuration properties.
     */
    @JvmName("pakiayhplrhncdpc")
    public suspend fun properties(`value`: Output<DevOpsConfigurationPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ukjwqxjnyabupfjd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The security connector name.
     */
    @JvmName("ojfjmvntsiulivlx")
    public suspend fun securityConnectorName(`value`: Output<String>) {
        this.securityConnectorName = value
    }

    /**
     * @param value DevOps Configuration properties.
     */
    @JvmName("ejcejeaplvwdramo")
    public suspend fun properties(`value`: DevOpsConfigurationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument DevOps Configuration properties.
     */
    @JvmName("rbceneucgtxxpdug")
    public suspend
    fun properties(argument: suspend DevOpsConfigurationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DevOpsConfigurationPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("akhynrqqdafpnukg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The security connector name.
     */
    @JvmName("tahfdepbxoejmsww")
    public suspend fun securityConnectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityConnectorName = mapped
    }

    internal fun build(): DevOpsConfigurationArgs = DevOpsConfigurationArgs(
        properties = properties,
        resourceGroupName = resourceGroupName,
        securityConnectorName = securityConnectorName,
    )
}
