@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.GovernanceRuleArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.GovernanceRuleSourceResourceType
import com.pulumi.azurenative.security.kotlin.enums.GovernanceRuleType
import com.pulumi.azurenative.security.kotlin.inputs.GovernanceRuleEmailNotificationArgs
import com.pulumi.azurenative.security.kotlin.inputs.GovernanceRuleEmailNotificationArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GovernanceRuleOwnerSourceArgs
import com.pulumi.azurenative.security.kotlin.inputs.GovernanceRuleOwnerSourceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Governance rule over a given scope
 * Azure REST API version: 2022-01-01-preview.
 * ## Example Usage
 * ### Create or update governance rule over management group scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var governanceRule = new AzureNative.Security.GovernanceRule("governanceRule", new()
 *     {
 *         Description = "A rule for a management group",
 *         DisplayName = "Management group rule",
 *         ExcludedScopes = new[]
 *         {
 *             "/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23",
 *         },
 *         GovernanceEmailNotification = new AzureNative.Security.Inputs.GovernanceRuleEmailNotificationArgs
 *         {
 *             DisableManagerEmailNotification = true,
 *             DisableOwnerEmailNotification = false,
 *         },
 *         IsDisabled = false,
 *         IsGracePeriod = true,
 *         OwnerSource = new AzureNative.Security.Inputs.GovernanceRuleOwnerSourceArgs
 *         {
 *             Type = "Manually",
 *             Value = "user@contoso.com",
 *         },
 *         RemediationTimeframe = "7.00:00:00",
 *         RuleId = "ad9a8e26-29d9-4829-bb30-e597a58cdbb8",
 *         RulePriority = 200,
 *         RuleType = "Integrated",
 *         Scope = "providers/Microsoft.Management/managementGroups/contoso",
 *         SourceResourceType = "Assessments",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewGovernanceRule(ctx, "governanceRule", &security.GovernanceRuleArgs{
 * 			Description: pulumi.String("A rule for a management group"),
 * 			DisplayName: pulumi.String("Management group rule"),
 * 			ExcludedScopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23"),
 * 			},
 * 			GovernanceEmailNotification: &security.GovernanceRuleEmailNotificationArgs{
 * 				DisableManagerEmailNotification: pulumi.Bool(true),
 * 				DisableOwnerEmailNotification:   pulumi.Bool(false),
 * 			},
 * 			IsDisabled:    pulumi.Bool(false),
 * 			IsGracePeriod: pulumi.Bool(true),
 * 			OwnerSource: &security.GovernanceRuleOwnerSourceArgs{
 * 				Type:  pulumi.String("Manually"),
 * 				Value: pulumi.String("user@contoso.com"),
 * 			},
 * 			RemediationTimeframe: pulumi.String("7.00:00:00"),
 * 			RuleId:               pulumi.String("ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
 * 			RulePriority:         pulumi.Int(200),
 * 			RuleType:             pulumi.String("Integrated"),
 * 			Scope:                pulumi.String("providers/Microsoft.Management/managementGroups/contoso"),
 * 			SourceResourceType:   pulumi.String("Assessments"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.GovernanceRule;
 * import com.pulumi.azurenative.security.GovernanceRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var governanceRule = new GovernanceRule("governanceRule", GovernanceRuleArgs.builder()
 *             .description("A rule for a management group")
 *             .displayName("Management group rule")
 *             .excludedScopes("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23")
 *             .governanceEmailNotification(Map.ofEntries(
 *                 Map.entry("disableManagerEmailNotification", true),
 *                 Map.entry("disableOwnerEmailNotification", false)
 *             ))
 *             .isDisabled(false)
 *             .isGracePeriod(true)
 *             .ownerSource(Map.ofEntries(
 *                 Map.entry("type", "Manually"),
 *                 Map.entry("value", "user@contoso.com")
 *             ))
 *             .remediationTimeframe("7.00:00:00")
 *             .ruleId("ad9a8e26-29d9-4829-bb30-e597a58cdbb8")
 *             .rulePriority(200)
 *             .ruleType("Integrated")
 *             .scope("providers/Microsoft.Management/managementGroups/contoso")
 *             .sourceResourceType("Assessments")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update governance rule over security connector scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var governanceRule = new AzureNative.Security.GovernanceRule("governanceRule", new()
 *     {
 *         Description = "A rule on critical GCP recommendations",
 *         DisplayName = "GCP Admin's rule",
 *         GovernanceEmailNotification = new AzureNative.Security.Inputs.GovernanceRuleEmailNotificationArgs
 *         {
 *             DisableManagerEmailNotification = true,
 *             DisableOwnerEmailNotification = false,
 *         },
 *         IsDisabled = false,
 *         IsGracePeriod = true,
 *         OwnerSource = new AzureNative.Security.Inputs.GovernanceRuleOwnerSourceArgs
 *         {
 *             Type = "Manually",
 *             Value = "user@contoso.com",
 *         },
 *         RemediationTimeframe = "7.00:00:00",
 *         RuleId = "ad9a8e26-29d9-4829-bb30-e597a58cdbb8",
 *         RulePriority = 200,
 *         RuleType = "Integrated",
 *         Scope = "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/gcpResourceGroup/providers/Microsoft.Security/securityConnectors/gcpconnector",
 *         SourceResourceType = "Assessments",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewGovernanceRule(ctx, "governanceRule", &security.GovernanceRuleArgs{
 * 			Description: pulumi.String("A rule on critical GCP recommendations"),
 * 			DisplayName: pulumi.String("GCP Admin's rule"),
 * 			GovernanceEmailNotification: &security.GovernanceRuleEmailNotificationArgs{
 * 				DisableManagerEmailNotification: pulumi.Bool(true),
 * 				DisableOwnerEmailNotification:   pulumi.Bool(false),
 * 			},
 * 			IsDisabled:    pulumi.Bool(false),
 * 			IsGracePeriod: pulumi.Bool(true),
 * 			OwnerSource: &security.GovernanceRuleOwnerSourceArgs{
 * 				Type:  pulumi.String("Manually"),
 * 				Value: pulumi.String("user@contoso.com"),
 * 			},
 * 			RemediationTimeframe: pulumi.String("7.00:00:00"),
 * 			RuleId:               pulumi.String("ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
 * 			RulePriority:         pulumi.Int(200),
 * 			RuleType:             pulumi.String("Integrated"),
 * 			Scope:                pulumi.String("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/gcpResourceGroup/providers/Microsoft.Security/securityConnectors/gcpconnector"),
 * 			SourceResourceType:   pulumi.String("Assessments"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.GovernanceRule;
 * import com.pulumi.azurenative.security.GovernanceRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var governanceRule = new GovernanceRule("governanceRule", GovernanceRuleArgs.builder()
 *             .description("A rule on critical GCP recommendations")
 *             .displayName("GCP Admin's rule")
 *             .governanceEmailNotification(Map.ofEntries(
 *                 Map.entry("disableManagerEmailNotification", true),
 *                 Map.entry("disableOwnerEmailNotification", false)
 *             ))
 *             .isDisabled(false)
 *             .isGracePeriod(true)
 *             .ownerSource(Map.ofEntries(
 *                 Map.entry("type", "Manually"),
 *                 Map.entry("value", "user@contoso.com")
 *             ))
 *             .remediationTimeframe("7.00:00:00")
 *             .ruleId("ad9a8e26-29d9-4829-bb30-e597a58cdbb8")
 *             .rulePriority(200)
 *             .ruleType("Integrated")
 *             .scope("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/gcpResourceGroup/providers/Microsoft.Security/securityConnectors/gcpconnector")
 *             .sourceResourceType("Assessments")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update governance rule over subscription scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var governanceRule = new AzureNative.Security.GovernanceRule("governanceRule", new()
 *     {
 *         Description = "A rule for critical recommendations",
 *         DisplayName = "Admin's rule",
 *         GovernanceEmailNotification = new AzureNative.Security.Inputs.GovernanceRuleEmailNotificationArgs
 *         {
 *             DisableManagerEmailNotification = false,
 *             DisableOwnerEmailNotification = false,
 *         },
 *         IsDisabled = false,
 *         IsGracePeriod = true,
 *         OwnerSource = new AzureNative.Security.Inputs.GovernanceRuleOwnerSourceArgs
 *         {
 *             Type = "Manually",
 *             Value = "user@contoso.com",
 *         },
 *         RemediationTimeframe = "7.00:00:00",
 *         RuleId = "ad9a8e26-29d9-4829-bb30-e597a58cdbb8",
 *         RulePriority = 200,
 *         RuleType = "Integrated",
 *         Scope = "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23",
 *         SourceResourceType = "Assessments",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewGovernanceRule(ctx, "governanceRule", &security.GovernanceRuleArgs{
 * 			Description: pulumi.String("A rule for critical recommendations"),
 * 			DisplayName: pulumi.String("Admin's rule"),
 * 			GovernanceEmailNotification: &security.GovernanceRuleEmailNotificationArgs{
 * 				DisableManagerEmailNotification: pulumi.Bool(false),
 * 				DisableOwnerEmailNotification:   pulumi.Bool(false),
 * 			},
 * 			IsDisabled:    pulumi.Bool(false),
 * 			IsGracePeriod: pulumi.Bool(true),
 * 			OwnerSource: &security.GovernanceRuleOwnerSourceArgs{
 * 				Type:  pulumi.String("Manually"),
 * 				Value: pulumi.String("user@contoso.com"),
 * 			},
 * 			RemediationTimeframe: pulumi.String("7.00:00:00"),
 * 			RuleId:               pulumi.String("ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
 * 			RulePriority:         pulumi.Int(200),
 * 			RuleType:             pulumi.String("Integrated"),
 * 			Scope:                pulumi.String("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23"),
 * 			SourceResourceType:   pulumi.String("Assessments"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.GovernanceRule;
 * import com.pulumi.azurenative.security.GovernanceRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var governanceRule = new GovernanceRule("governanceRule", GovernanceRuleArgs.builder()
 *             .description("A rule for critical recommendations")
 *             .displayName("Admin's rule")
 *             .governanceEmailNotification(Map.ofEntries(
 *                 Map.entry("disableManagerEmailNotification", false),
 *                 Map.entry("disableOwnerEmailNotification", false)
 *             ))
 *             .isDisabled(false)
 *             .isGracePeriod(true)
 *             .ownerSource(Map.ofEntries(
 *                 Map.entry("type", "Manually"),
 *                 Map.entry("value", "user@contoso.com")
 *             ))
 *             .remediationTimeframe("7.00:00:00")
 *             .ruleId("ad9a8e26-29d9-4829-bb30-e597a58cdbb8")
 *             .rulePriority(200)
 *             .ruleType("Integrated")
 *             .scope("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23")
 *             .sourceResourceType("Assessments")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:GovernanceRule ad9a8e26-29d9-4829-bb30-e597a58cdbb8 /{scope}/providers/Microsoft.Security/governanceRules/{ruleId}
 * ```
 * @property description Description of the governance rule
 * @property displayName Display name of the governance rule
 * @property excludedScopes Excluded scopes, filter out the descendants of the scope (on management scopes)
 * @property governanceEmailNotification The email notifications settings for the governance rule, states whether to disable notifications for mangers and owners
 * @property includeMemberScopes Defines whether the rule is management scope rule (master connector as a single scope or management scope)
 * @property isDisabled Defines whether the rule is active/inactive
 * @property isGracePeriod Defines whether there is a grace period on the governance rule
 * @property ownerSource The owner source for the governance rule - e.g. Manually by user@contoso.com - see example
 * @property remediationTimeframe Governance rule remediation timeframe - this is the time that will affect on the grace-period duration e.g. 7.00:00:00 - means 7 days
 * @property ruleId The governance rule key - unique key for the standard governance rule (GUID)
 * @property rulePriority The governance rule priority, priority to the lower number. Rules with the same priority on the same scope will not be allowed
 * @property ruleType The rule type of the governance rule, defines the source of the rule e.g. Integrated
 * @property scope The scope of the Governance rules. Valid scopes are: management group (format: 'providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: 'subscriptions/{subscriptionId}'), or security connector (format: 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'
 * @property sourceResourceType The governance rule source, what the rule affects, e.g. Assessments
 */
public data class GovernanceRuleArgs(
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val excludedScopes: Output<List<String>>? = null,
    public val governanceEmailNotification: Output<GovernanceRuleEmailNotificationArgs>? = null,
    public val includeMemberScopes: Output<Boolean>? = null,
    public val isDisabled: Output<Boolean>? = null,
    public val isGracePeriod: Output<Boolean>? = null,
    public val ownerSource: Output<GovernanceRuleOwnerSourceArgs>? = null,
    public val remediationTimeframe: Output<String>? = null,
    public val ruleId: Output<String>? = null,
    public val rulePriority: Output<Int>? = null,
    public val ruleType: Output<Either<String, GovernanceRuleType>>? = null,
    public val scope: Output<String>? = null,
    public val sourceResourceType: Output<Either<String, GovernanceRuleSourceResourceType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.GovernanceRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.security.GovernanceRuleArgs =
        com.pulumi.azurenative.security.GovernanceRuleArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .excludedScopes(excludedScopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .governanceEmailNotification(
                governanceEmailNotification?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .includeMemberScopes(includeMemberScopes?.applyValue({ args0 -> args0 }))
            .isDisabled(isDisabled?.applyValue({ args0 -> args0 }))
            .isGracePeriod(isGracePeriod?.applyValue({ args0 -> args0 }))
            .ownerSource(ownerSource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .remediationTimeframe(remediationTimeframe?.applyValue({ args0 -> args0 }))
            .ruleId(ruleId?.applyValue({ args0 -> args0 }))
            .rulePriority(rulePriority?.applyValue({ args0 -> args0 }))
            .ruleType(
                ruleType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .scope(scope?.applyValue({ args0 -> args0 }))
            .sourceResourceType(
                sourceResourceType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [GovernanceRuleArgs].
 */
@PulumiTagMarker
public class GovernanceRuleArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var excludedScopes: Output<List<String>>? = null

    private var governanceEmailNotification: Output<GovernanceRuleEmailNotificationArgs>? = null

    private var includeMemberScopes: Output<Boolean>? = null

    private var isDisabled: Output<Boolean>? = null

    private var isGracePeriod: Output<Boolean>? = null

    private var ownerSource: Output<GovernanceRuleOwnerSourceArgs>? = null

    private var remediationTimeframe: Output<String>? = null

    private var ruleId: Output<String>? = null

    private var rulePriority: Output<Int>? = null

    private var ruleType: Output<Either<String, GovernanceRuleType>>? = null

    private var scope: Output<String>? = null

    private var sourceResourceType: Output<Either<String, GovernanceRuleSourceResourceType>>? = null

    /**
     * @param value Description of the governance rule
     */
    @JvmName("amopvhhqddlnachu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Display name of the governance rule
     */
    @JvmName("affxtypatmbxikvl")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Excluded scopes, filter out the descendants of the scope (on management scopes)
     */
    @JvmName("hjrgbankcqrljywt")
    public suspend fun excludedScopes(`value`: Output<List<String>>) {
        this.excludedScopes = value
    }

    @JvmName("uhiknisgoacnjbef")
    public suspend fun excludedScopes(vararg values: Output<String>) {
        this.excludedScopes = Output.all(values.asList())
    }

    /**
     * @param values Excluded scopes, filter out the descendants of the scope (on management scopes)
     */
    @JvmName("jwxnkwjwjukourgk")
    public suspend fun excludedScopes(values: List<Output<String>>) {
        this.excludedScopes = Output.all(values)
    }

    /**
     * @param value The email notifications settings for the governance rule, states whether to disable notifications for mangers and owners
     */
    @JvmName("acuiixlcyvpafawo")
    public suspend
    fun governanceEmailNotification(`value`: Output<GovernanceRuleEmailNotificationArgs>) {
        this.governanceEmailNotification = value
    }

    /**
     * @param value Defines whether the rule is management scope rule (master connector as a single scope or management scope)
     */
    @JvmName("aplpdshvovkssxmd")
    public suspend fun includeMemberScopes(`value`: Output<Boolean>) {
        this.includeMemberScopes = value
    }

    /**
     * @param value Defines whether the rule is active/inactive
     */
    @JvmName("jymctdcpfdbfrmsk")
    public suspend fun isDisabled(`value`: Output<Boolean>) {
        this.isDisabled = value
    }

    /**
     * @param value Defines whether there is a grace period on the governance rule
     */
    @JvmName("bjepwpgjsftysvvp")
    public suspend fun isGracePeriod(`value`: Output<Boolean>) {
        this.isGracePeriod = value
    }

    /**
     * @param value The owner source for the governance rule - e.g. Manually by user@contoso.com - see example
     */
    @JvmName("aqtyvlwmcsoiqwnv")
    public suspend fun ownerSource(`value`: Output<GovernanceRuleOwnerSourceArgs>) {
        this.ownerSource = value
    }

    /**
     * @param value Governance rule remediation timeframe - this is the time that will affect on the grace-period duration e.g. 7.00:00:00 - means 7 days
     */
    @JvmName("yrkpygbjgctrejtv")
    public suspend fun remediationTimeframe(`value`: Output<String>) {
        this.remediationTimeframe = value
    }

    /**
     * @param value The governance rule key - unique key for the standard governance rule (GUID)
     */
    @JvmName("jmtdfqkvjqdlsacf")
    public suspend fun ruleId(`value`: Output<String>) {
        this.ruleId = value
    }

    /**
     * @param value The governance rule priority, priority to the lower number. Rules with the same priority on the same scope will not be allowed
     */
    @JvmName("hcqcaqoldnrmgmjp")
    public suspend fun rulePriority(`value`: Output<Int>) {
        this.rulePriority = value
    }

    /**
     * @param value The rule type of the governance rule, defines the source of the rule e.g. Integrated
     */
    @JvmName("tpbberhwixqhtnuu")
    public suspend fun ruleType(`value`: Output<Either<String, GovernanceRuleType>>) {
        this.ruleType = value
    }

    /**
     * @param value The scope of the Governance rules. Valid scopes are: management group (format: 'providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: 'subscriptions/{subscriptionId}'), or security connector (format: 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'
     */
    @JvmName("vgjiqofrjqltnuvc")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The governance rule source, what the rule affects, e.g. Assessments
     */
    @JvmName("kiwfhskkcceqndgh")
    public suspend
    fun sourceResourceType(`value`: Output<Either<String, GovernanceRuleSourceResourceType>>) {
        this.sourceResourceType = value
    }

    /**
     * @param value Description of the governance rule
     */
    @JvmName("saojfvqinpjadopc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Display name of the governance rule
     */
    @JvmName("pnahhbgsgvmuguay")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Excluded scopes, filter out the descendants of the scope (on management scopes)
     */
    @JvmName("yngaglqiawgytaxm")
    public suspend fun excludedScopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedScopes = mapped
    }

    /**
     * @param values Excluded scopes, filter out the descendants of the scope (on management scopes)
     */
    @JvmName("adpyxprlsypnkfyd")
    public suspend fun excludedScopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedScopes = mapped
    }

    /**
     * @param value The email notifications settings for the governance rule, states whether to disable notifications for mangers and owners
     */
    @JvmName("cmavkbkxntfirnnx")
    public suspend fun governanceEmailNotification(`value`: GovernanceRuleEmailNotificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.governanceEmailNotification = mapped
    }

    /**
     * @param argument The email notifications settings for the governance rule, states whether to disable notifications for mangers and owners
     */
    @JvmName("pdhrurtoruwkkktj")
    public suspend
    fun governanceEmailNotification(argument: suspend GovernanceRuleEmailNotificationArgsBuilder.() -> Unit) {
        val toBeMapped = GovernanceRuleEmailNotificationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.governanceEmailNotification = mapped
    }

    /**
     * @param value Defines whether the rule is management scope rule (master connector as a single scope or management scope)
     */
    @JvmName("uvdnqlvmeoeajdny")
    public suspend fun includeMemberScopes(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeMemberScopes = mapped
    }

    /**
     * @param value Defines whether the rule is active/inactive
     */
    @JvmName("ioglfxtbaohusoew")
    public suspend fun isDisabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDisabled = mapped
    }

    /**
     * @param value Defines whether there is a grace period on the governance rule
     */
    @JvmName("athcpmlcngagtmhc")
    public suspend fun isGracePeriod(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isGracePeriod = mapped
    }

    /**
     * @param value The owner source for the governance rule - e.g. Manually by user@contoso.com - see example
     */
    @JvmName("eqociabtoruodopu")
    public suspend fun ownerSource(`value`: GovernanceRuleOwnerSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerSource = mapped
    }

    /**
     * @param argument The owner source for the governance rule - e.g. Manually by user@contoso.com - see example
     */
    @JvmName("gdtavmmuuxfaxfvq")
    public suspend
    fun ownerSource(argument: suspend GovernanceRuleOwnerSourceArgsBuilder.() -> Unit) {
        val toBeMapped = GovernanceRuleOwnerSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ownerSource = mapped
    }

    /**
     * @param value Governance rule remediation timeframe - this is the time that will affect on the grace-period duration e.g. 7.00:00:00 - means 7 days
     */
    @JvmName("tdgvlrknawjeyvir")
    public suspend fun remediationTimeframe(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remediationTimeframe = mapped
    }

    /**
     * @param value The governance rule key - unique key for the standard governance rule (GUID)
     */
    @JvmName("nqnlwgmqfukwhrci")
    public suspend fun ruleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleId = mapped
    }

    /**
     * @param value The governance rule priority, priority to the lower number. Rules with the same priority on the same scope will not be allowed
     */
    @JvmName("dqqbkcojytijukif")
    public suspend fun rulePriority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rulePriority = mapped
    }

    /**
     * @param value The rule type of the governance rule, defines the source of the rule e.g. Integrated
     */
    @JvmName("pkqovpytluotpysu")
    public suspend fun ruleType(`value`: Either<String, GovernanceRuleType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    /**
     * @param value The rule type of the governance rule, defines the source of the rule e.g. Integrated
     */
    @JvmName("svibxnaueuvdxhur")
    public fun ruleType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GovernanceRuleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    /**
     * @param value The rule type of the governance rule, defines the source of the rule e.g. Integrated
     */
    @JvmName("kjykxaalhalhglli")
    public fun ruleType(`value`: GovernanceRuleType) {
        val toBeMapped = Either.ofRight<String, GovernanceRuleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    /**
     * @param value The scope of the Governance rules. Valid scopes are: management group (format: 'providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: 'subscriptions/{subscriptionId}'), or security connector (format: 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'
     */
    @JvmName("tqptplqlnqkixvhq")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The governance rule source, what the rule affects, e.g. Assessments
     */
    @JvmName("knxxdotrrvnhpsrd")
    public suspend
    fun sourceResourceType(`value`: Either<String, GovernanceRuleSourceResourceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResourceType = mapped
    }

    /**
     * @param value The governance rule source, what the rule affects, e.g. Assessments
     */
    @JvmName("tpttendsonlqdaat")
    public fun sourceResourceType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GovernanceRuleSourceResourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceResourceType = mapped
    }

    /**
     * @param value The governance rule source, what the rule affects, e.g. Assessments
     */
    @JvmName("oaecbowgbcwqfall")
    public fun sourceResourceType(`value`: GovernanceRuleSourceResourceType) {
        val toBeMapped = Either.ofRight<String, GovernanceRuleSourceResourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceResourceType = mapped
    }

    internal fun build(): GovernanceRuleArgs = GovernanceRuleArgs(
        description = description,
        displayName = displayName,
        excludedScopes = excludedScopes,
        governanceEmailNotification = governanceEmailNotification,
        includeMemberScopes = includeMemberScopes,
        isDisabled = isDisabled,
        isGracePeriod = isGracePeriod,
        ownerSource = ownerSource,
        remediationTimeframe = remediationTimeframe,
        ruleId = ruleId,
        rulePriority = rulePriority,
        ruleType = ruleType,
        scope = scope,
        sourceResourceType = sourceResourceType,
    )
}
