@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.ServerVulnerabilityAssessmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the server vulnerability assessment details on a resource
 * Azure REST API version: 2020-01-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * ## Example Usage
 * ### Create a server vulnerability assessments on a resource. Only 'default' resource is supported. Once creating the resource, the server will be onboarded to vulnerability assessment by Microsoft.Security
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverVulnerabilityAssessment = new AzureNative.Security.ServerVulnerabilityAssessment("serverVulnerabilityAssessment", new()
 *     {
 *         ResourceGroupName = "rg1",
 *         ResourceName = "vm1",
 *         ResourceNamespace = "Microsoft.Compute",
 *         ResourceType = "virtualMachines",
 *         ServerVulnerabilityAssessment = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewServerVulnerabilityAssessment(ctx, "serverVulnerabilityAssessment", &security.ServerVulnerabilityAssessmentArgs{
 * 			ResourceGroupName:             pulumi.String("rg1"),
 * 			ResourceName:                  pulumi.String("vm1"),
 * 			ResourceNamespace:             pulumi.String("Microsoft.Compute"),
 * 			ResourceType:                  pulumi.String("virtualMachines"),
 * 			ServerVulnerabilityAssessment: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.ServerVulnerabilityAssessment;
 * import com.pulumi.azurenative.security.ServerVulnerabilityAssessmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverVulnerabilityAssessment = new ServerVulnerabilityAssessment("serverVulnerabilityAssessment", ServerVulnerabilityAssessmentArgs.builder()
 *             .resourceGroupName("rg1")
 *             .resourceName("vm1")
 *             .resourceNamespace("Microsoft.Compute")
 *             .resourceType("virtualMachines")
 *             .serverVulnerabilityAssessment("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:ServerVulnerabilityAssessment default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/serverVulnerabilityAssessments/{serverVulnerabilityAssessment}
 * ```
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property resourceName Name of the resource.
 * @property resourceNamespace The Namespace of the resource.
 * @property resourceType The type of the resource.
 * @property serverVulnerabilityAssessment ServerVulnerabilityAssessment status. only a 'default' value is supported.
 */
public data class ServerVulnerabilityAssessmentArgs(
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val resourceNamespace: Output<String>? = null,
    public val resourceType: Output<String>? = null,
    public val serverVulnerabilityAssessment: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.ServerVulnerabilityAssessmentArgs> {
    override fun toJava(): com.pulumi.azurenative.security.ServerVulnerabilityAssessmentArgs =
        com.pulumi.azurenative.security.ServerVulnerabilityAssessmentArgs.builder()
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .resourceNamespace(resourceNamespace?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 }))
            .serverVulnerabilityAssessment(
                serverVulnerabilityAssessment?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [ServerVulnerabilityAssessmentArgs].
 */
@PulumiTagMarker
public class ServerVulnerabilityAssessmentArgsBuilder internal constructor() {
    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var resourceNamespace: Output<String>? = null

    private var resourceType: Output<String>? = null

    private var serverVulnerabilityAssessment: Output<String>? = null

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("jdaxyjjxxsuxxnnd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the resource.
     */
    @JvmName("jdgwcqkiseidpwvm")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The Namespace of the resource.
     */
    @JvmName("qwnnhhiyigfliivt")
    public suspend fun resourceNamespace(`value`: Output<String>) {
        this.resourceNamespace = value
    }

    /**
     * @param value The type of the resource.
     */
    @JvmName("usnoxojwsducvcbh")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value ServerVulnerabilityAssessment status. only a 'default' value is supported.
     */
    @JvmName("xgqbacsgjuwlfvbd")
    public suspend fun serverVulnerabilityAssessment(`value`: Output<String>) {
        this.serverVulnerabilityAssessment = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("mhnnfmwafhicityf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the resource.
     */
    @JvmName("vprrkuxhshmmgjbr")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value The Namespace of the resource.
     */
    @JvmName("tgtuopurxpokvqyu")
    public suspend fun resourceNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceNamespace = mapped
    }

    /**
     * @param value The type of the resource.
     */
    @JvmName("ylstdkscmgbhaelw")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value ServerVulnerabilityAssessment status. only a 'default' value is supported.
     */
    @JvmName("undaywhakqajvuio")
    public suspend fun serverVulnerabilityAssessment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverVulnerabilityAssessment = mapped
    }

    internal fun build(): ServerVulnerabilityAssessmentArgs = ServerVulnerabilityAssessmentArgs(
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        resourceNamespace = resourceNamespace,
        resourceType = resourceType,
        serverVulnerabilityAssessment = serverVulnerabilityAssessment,
    )
}
