@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.SqlVulnerabilityAssessmentBaselineRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Rule results.
 * Azure REST API version: 2023-02-01-preview. Prior API version in Azure Native 1.x: 2020-07-01-preview.
 * ## Example Usage
 * ### Create a baseline
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlVulnerabilityAssessmentBaselineRule = new AzureNative.Security.SqlVulnerabilityAssessmentBaselineRule("sqlVulnerabilityAssessmentBaselineRule", new()
 *     {
 *         LatestScan = false,
 *         ResourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master",
 *         Results = new[]
 *         {
 *             new[]
 *             {
 *                 "userA",
 *                 "SELECT",
 *             },
 *             new[]
 *             {
 *                 "userB",
 *                 "SELECT",
 *             },
 *         },
 *         RuleId = "VA1234",
 *         WorkspaceId = "55555555-6666-7777-8888-999999999999",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewSqlVulnerabilityAssessmentBaselineRule(ctx, "sqlVulnerabilityAssessmentBaselineRule", &security.SqlVulnerabilityAssessmentBaselineRuleArgs{
 * 			LatestScan: pulumi.Bool(false),
 * 			ResourceId: pulumi.String("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master"),
 * 			Results: pulumi.StringArrayArray{
 * 				pulumi.StringArray{
 * 					pulumi.String("userA"),
 * 					pulumi.String("SELECT"),
 * 				},
 * 				pulumi.StringArray{
 * 					pulumi.String("userB"),
 * 					pulumi.String("SELECT"),
 * 				},
 * 			},
 * 			RuleId:      pulumi.String("VA1234"),
 * 			WorkspaceId: pulumi.String("55555555-6666-7777-8888-999999999999"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.SqlVulnerabilityAssessmentBaselineRule;
 * import com.pulumi.azurenative.security.SqlVulnerabilityAssessmentBaselineRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlVulnerabilityAssessmentBaselineRule = new SqlVulnerabilityAssessmentBaselineRule("sqlVulnerabilityAssessmentBaselineRule", SqlVulnerabilityAssessmentBaselineRuleArgs.builder()
 *             .latestScan(false)
 *             .resourceId("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master")
 *             .results(
 *                     "userA",
 *                     "SELECT",
 *                     "userB",
 *                     "SELECT")
 *             .ruleId("VA1234")
 *             .workspaceId("55555555-6666-7777-8888-999999999999")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a baseline using the latest scan results
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlVulnerabilityAssessmentBaselineRule = new AzureNative.Security.SqlVulnerabilityAssessmentBaselineRule("sqlVulnerabilityAssessmentBaselineRule", new()
 *     {
 *         LatestScan = true,
 *         ResourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master",
 *         Results = new[] {},
 *         RuleId = "VA1234",
 *         WorkspaceId = "55555555-6666-7777-8888-999999999999",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewSqlVulnerabilityAssessmentBaselineRule(ctx, "sqlVulnerabilityAssessmentBaselineRule", &security.SqlVulnerabilityAssessmentBaselineRuleArgs{
 * 			LatestScan:  pulumi.Bool(true),
 * 			ResourceId:  pulumi.String("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master"),
 * 			Results:     pulumi.StringArrayArray{},
 * 			RuleId:      pulumi.String("VA1234"),
 * 			WorkspaceId: pulumi.String("55555555-6666-7777-8888-999999999999"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.SqlVulnerabilityAssessmentBaselineRule;
 * import com.pulumi.azurenative.security.SqlVulnerabilityAssessmentBaselineRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlVulnerabilityAssessmentBaselineRule = new SqlVulnerabilityAssessmentBaselineRule("sqlVulnerabilityAssessmentBaselineRule", SqlVulnerabilityAssessmentBaselineRuleArgs.builder()
 *             .latestScan(true)
 *             .resourceId("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master")
 *             .results()
 *             .ruleId("VA1234")
 *             .workspaceId("55555555-6666-7777-8888-999999999999")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:SqlVulnerabilityAssessmentBaselineRule VA1234 /{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}
 * ```
 * @property latestScan Take results from latest scan.
 * @property resourceId The identifier of the resource.
 * @property results Expected results to be inserted into the baseline.
 * Leave this field empty it LatestScan == true.
 * @property ruleId The rule Id.
 * @property workspaceId The workspace Id.
 */
public data class SqlVulnerabilityAssessmentBaselineRuleArgs(
    public val latestScan: Output<Boolean>? = null,
    public val resourceId: Output<String>? = null,
    public val results: Output<List<List<String>>>? = null,
    public val ruleId: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.SqlVulnerabilityAssessmentBaselineRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.security.SqlVulnerabilityAssessmentBaselineRuleArgs =
        com.pulumi.azurenative.security.SqlVulnerabilityAssessmentBaselineRuleArgs.builder()
            .latestScan(latestScan?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .results(results?.applyValue({ args0 -> args0.map({ args0 -> args0.map({ args0 -> args0 }) }) }))
            .ruleId(ruleId?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlVulnerabilityAssessmentBaselineRuleArgs].
 */
@PulumiTagMarker
public class SqlVulnerabilityAssessmentBaselineRuleArgsBuilder internal constructor() {
    private var latestScan: Output<Boolean>? = null

    private var resourceId: Output<String>? = null

    private var results: Output<List<List<String>>>? = null

    private var ruleId: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value Take results from latest scan.
     */
    @JvmName("eeuomivqlgcelsmh")
    public suspend fun latestScan(`value`: Output<Boolean>) {
        this.latestScan = value
    }

    /**
     * @param value The identifier of the resource.
     */
    @JvmName("hkdwvjddnotkklyh")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Expected results to be inserted into the baseline.
     * Leave this field empty it LatestScan == true.
     */
    @JvmName("ducddklfvfcekbvp")
    public suspend fun results(`value`: Output<List<List<String>>>) {
        this.results = value
    }

    @JvmName("gtdkfmofdqjentup")
    public suspend fun results(vararg values: Output<List<String>>) {
        this.results = Output.all(values.asList())
    }

    /**
     * @param values Expected results to be inserted into the baseline.
     * Leave this field empty it LatestScan == true.
     */
    @JvmName("fitvsxmrsenbykvb")
    public suspend fun results(values: List<Output<List<String>>>) {
        this.results = Output.all(values)
    }

    /**
     * @param value The rule Id.
     */
    @JvmName("seftjvubdcprjcgk")
    public suspend fun ruleId(`value`: Output<String>) {
        this.ruleId = value
    }

    /**
     * @param value The workspace Id.
     */
    @JvmName("jcvyvxwlelkyoxob")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value Take results from latest scan.
     */
    @JvmName("lrdsgipqqdxwioeg")
    public suspend fun latestScan(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.latestScan = mapped
    }

    /**
     * @param value The identifier of the resource.
     */
    @JvmName("pmfrbxgqegqdhmqw")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value Expected results to be inserted into the baseline.
     * Leave this field empty it LatestScan == true.
     */
    @JvmName("nlahjvewgtpflajh")
    public suspend fun results(`value`: List<List<String>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.results = mapped
    }

    /**
     * @param values Expected results to be inserted into the baseline.
     * Leave this field empty it LatestScan == true.
     */
    @JvmName("umnkmcxfryvyvxvs")
    public suspend fun results(vararg values: List<String>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.results = mapped
    }

    /**
     * @param value The rule Id.
     */
    @JvmName("vobvdeuwabemprov")
    public suspend fun ruleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleId = mapped
    }

    /**
     * @param value The workspace Id.
     */
    @JvmName("wnrrkpeybivmjamf")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): SqlVulnerabilityAssessmentBaselineRuleArgs =
        SqlVulnerabilityAssessmentBaselineRuleArgs(
            latestScan = latestScan,
            resourceId = resourceId,
            results = results,
            ruleId = ruleId,
            workspaceId = workspaceId,
        )
}
