@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.kotlin.outputs.StandardComponentPropertiesResponse
import com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.security.kotlin.outputs.StandardComponentPropertiesResponse.Companion.toKotlin as standardComponentPropertiesResponseToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Standard].
 */
@PulumiTagMarker
public class StandardResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StandardArgs = StandardArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StandardArgsBuilder.() -> Unit) {
        val builder = StandardArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Standard {
        val builtJavaResource = com.pulumi.azurenative.security.Standard(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Standard(builtJavaResource)
    }
}

/**
 * Security Standard on a resource
 * Azure REST API version: 2021-08-01-preview. Prior API version in Azure Native 1.x: 2021-08-01-preview.
 * ## Example Usage
 * ### Create a security standard on a specified scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var standard = new AzureNative.Security.Standard("standard", new()
 *     {
 *         Category = "SecurityCenter",
 *         Components = new[]
 *         {
 *             new AzureNative.Security.Inputs.StandardComponentPropertiesArgs
 *             {
 *                 Key = "1195afff-c881-495e-9bc5-1486211ae03f",
 *             },
 *             new AzureNative.Security.Inputs.StandardComponentPropertiesArgs
 *             {
 *                 Key = "dbd0cb49-b563-45e7-9724-889e799fa648",
 *             },
 *         },
 *         Description = "description of Azure Test Security Standard 1",
 *         DisplayName = "Azure Test Security Standard 1",
 *         ResourceGroupName = "myResourceGroup",
 *         StandardId = "8bb8be0a-6010-4789-812f-e4d661c4ed0e",
 *         SupportedClouds = new[]
 *         {
 *             AzureNative.Security.StandardSupportedClouds.GCP,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewStandard(ctx, "standard", &security.StandardArgs{
 * 			Category: pulumi.String("SecurityCenter"),
 * 			Components: []security.StandardComponentPropertiesArgs{
 * 				{
 * 					Key: pulumi.String("1195afff-c881-495e-9bc5-1486211ae03f"),
 * 				},
 * 				{
 * 					Key: pulumi.String("dbd0cb49-b563-45e7-9724-889e799fa648"),
 * 				},
 * 			},
 * 			Description:       pulumi.String("description of Azure Test Security Standard 1"),
 * 			DisplayName:       pulumi.String("Azure Test Security Standard 1"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StandardId:        pulumi.String("8bb8be0a-6010-4789-812f-e4d661c4ed0e"),
 * 			SupportedClouds: []security.StandardSupportedClouds{
 * 				security.StandardSupportedCloudsGCP,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Standard;
 * import com.pulumi.azurenative.security.StandardArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var standard = new Standard("standard", StandardArgs.builder()
 *             .category("SecurityCenter")
 *             .components(
 *                 Map.of("key", "1195afff-c881-495e-9bc5-1486211ae03f"),
 *                 Map.of("key", "dbd0cb49-b563-45e7-9724-889e799fa648"))
 *             .description("description of Azure Test Security Standard 1")
 *             .displayName("Azure Test Security Standard 1")
 *             .resourceGroupName("myResourceGroup")
 *             .standardId("8bb8be0a-6010-4789-812f-e4d661c4ed0e")
 *             .supportedClouds("GCP")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:Standard 8bb8be0a-6010-4789-812f-e4d661c4ed0e /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/standards/{standardId}
 * ```
 */
public class Standard internal constructor(
    override val javaResource: com.pulumi.azurenative.security.Standard,
) : KotlinCustomResource(javaResource, StandardMapper) {
    /**
     * category of the standard provided
     */
    public val category: Output<String>?
        get() = javaResource.category().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * List of component objects containing component unique keys (such as assessment keys) to apply to standard scope.  Currently only supports assessment keys.
     */
    public val components: Output<List<StandardComponentPropertiesResponse>>?
        get() = javaResource.components().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> standardComponentPropertiesResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * description of the standard
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * display name of the standard, equivalent to the standardId
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Entity tag is used for comparing two or more entities from the same requested resource.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Kind of the resource
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Location where the resource is stored
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * standard type (Custom or BuiltIn only currently)
     */
    public val standardType: Output<String>
        get() = javaResource.standardType().applyValue({ args0 -> args0 })

    /**
     * List of all standard supported clouds.
     */
    public val supportedClouds: Output<List<String>>?
        get() = javaResource.supportedClouds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * A list of key value pairs that describe the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object StandardMapper : ResourceMapper<Standard> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.Standard::class == javaResource::class

    override fun map(javaResource: Resource): Standard = Standard(
        javaResource as
            com.pulumi.azurenative.security.Standard,
    )
}

/**
 * @see [Standard].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Standard].
 */
public suspend fun standard(name: String, block: suspend StandardResourceBuilder.() -> Unit):
    Standard {
    val builder = StandardResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Standard].
 * @param name The _unique_ name of the resulting resource.
 */
public fun standard(name: String): Standard {
    val builder = StandardResourceBuilder()
    builder.name(name)
    return builder.build()
}
