@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.StandardArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.StandardSupportedClouds
import com.pulumi.azurenative.security.kotlin.inputs.StandardComponentPropertiesArgs
import com.pulumi.azurenative.security.kotlin.inputs.StandardComponentPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Security Standard on a resource
 * Azure REST API version: 2021-08-01-preview. Prior API version in Azure Native 1.x: 2021-08-01-preview.
 * ## Example Usage
 * ### Create a security standard on a specified scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var standard = new AzureNative.Security.Standard("standard", new()
 *     {
 *         Category = "SecurityCenter",
 *         Components = new[]
 *         {
 *             new AzureNative.Security.Inputs.StandardComponentPropertiesArgs
 *             {
 *                 Key = "1195afff-c881-495e-9bc5-1486211ae03f",
 *             },
 *             new AzureNative.Security.Inputs.StandardComponentPropertiesArgs
 *             {
 *                 Key = "dbd0cb49-b563-45e7-9724-889e799fa648",
 *             },
 *         },
 *         Description = "description of Azure Test Security Standard 1",
 *         DisplayName = "Azure Test Security Standard 1",
 *         ResourceGroupName = "myResourceGroup",
 *         StandardId = "8bb8be0a-6010-4789-812f-e4d661c4ed0e",
 *         SupportedClouds = new[]
 *         {
 *             AzureNative.Security.StandardSupportedClouds.GCP,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewStandard(ctx, "standard", &security.StandardArgs{
 * 			Category: pulumi.String("SecurityCenter"),
 * 			Components: []security.StandardComponentPropertiesArgs{
 * 				{
 * 					Key: pulumi.String("1195afff-c881-495e-9bc5-1486211ae03f"),
 * 				},
 * 				{
 * 					Key: pulumi.String("dbd0cb49-b563-45e7-9724-889e799fa648"),
 * 				},
 * 			},
 * 			Description:       pulumi.String("description of Azure Test Security Standard 1"),
 * 			DisplayName:       pulumi.String("Azure Test Security Standard 1"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StandardId:        pulumi.String("8bb8be0a-6010-4789-812f-e4d661c4ed0e"),
 * 			SupportedClouds: []security.StandardSupportedClouds{
 * 				security.StandardSupportedCloudsGCP,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Standard;
 * import com.pulumi.azurenative.security.StandardArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var standard = new Standard("standard", StandardArgs.builder()
 *             .category("SecurityCenter")
 *             .components(
 *                 Map.of("key", "1195afff-c881-495e-9bc5-1486211ae03f"),
 *                 Map.of("key", "dbd0cb49-b563-45e7-9724-889e799fa648"))
 *             .description("description of Azure Test Security Standard 1")
 *             .displayName("Azure Test Security Standard 1")
 *             .resourceGroupName("myResourceGroup")
 *             .standardId("8bb8be0a-6010-4789-812f-e4d661c4ed0e")
 *             .supportedClouds("GCP")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:Standard 8bb8be0a-6010-4789-812f-e4d661c4ed0e /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/standards/{standardId}
 * ```
 * @property category category of the standard provided
 * @property components List of component objects containing component unique keys (such as assessment keys) to apply to standard scope.  Currently only supports assessment keys.
 * @property description description of the standard
 * @property displayName display name of the standard, equivalent to the standardId
 * @property kind Kind of the resource
 * @property location Location where the resource is stored
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property standardId The Security Standard key - unique key for the standard type
 * @property supportedClouds List of all standard supported clouds.
 * @property tags A list of key value pairs that describe the resource.
 */
public data class StandardArgs(
    public val category: Output<String>? = null,
    public val components: Output<List<StandardComponentPropertiesArgs>>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val standardId: Output<String>? = null,
    public val supportedClouds: Output<List<StandardSupportedClouds>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.StandardArgs> {
    override fun toJava(): com.pulumi.azurenative.security.StandardArgs =
        com.pulumi.azurenative.security.StandardArgs.builder()
            .category(category?.applyValue({ args0 -> args0 }))
            .components(
                components?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .standardId(standardId?.applyValue({ args0 -> args0 }))
            .supportedClouds(
                supportedClouds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [StandardArgs].
 */
@PulumiTagMarker
public class StandardArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var components: Output<List<StandardComponentPropertiesArgs>>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var standardId: Output<String>? = null

    private var supportedClouds: Output<List<StandardSupportedClouds>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value category of the standard provided
     */
    @JvmName("qjyinvmyxbqerwuf")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value List of component objects containing component unique keys (such as assessment keys) to apply to standard scope.  Currently only supports assessment keys.
     */
    @JvmName("vlwamfgfixyllijt")
    public suspend fun components(`value`: Output<List<StandardComponentPropertiesArgs>>) {
        this.components = value
    }

    @JvmName("nlsiwfvxbenffqoa")
    public suspend fun components(vararg values: Output<StandardComponentPropertiesArgs>) {
        this.components = Output.all(values.asList())
    }

    /**
     * @param values List of component objects containing component unique keys (such as assessment keys) to apply to standard scope.  Currently only supports assessment keys.
     */
    @JvmName("maydmwqmwjtcgqek")
    public suspend fun components(values: List<Output<StandardComponentPropertiesArgs>>) {
        this.components = Output.all(values)
    }

    /**
     * @param value description of the standard
     */
    @JvmName("ekerrmlnpuqqnyia")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value display name of the standard, equivalent to the standardId
     */
    @JvmName("ceshovqvddtficuv")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Kind of the resource
     */
    @JvmName("ghawrboxkumicqpg")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Location where the resource is stored
     */
    @JvmName("vbermtopwpdvbgap")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("tqeddbhkhhtjeupj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Security Standard key - unique key for the standard type
     */
    @JvmName("obsncmcdqgvwvndg")
    public suspend fun standardId(`value`: Output<String>) {
        this.standardId = value
    }

    /**
     * @param value List of all standard supported clouds.
     */
    @JvmName("qcaeqejukmfyvmfi")
    public suspend fun supportedClouds(`value`: Output<List<StandardSupportedClouds>>) {
        this.supportedClouds = value
    }

    @JvmName("nwcoobfkwtxjeerh")
    public suspend fun supportedClouds(vararg values: Output<StandardSupportedClouds>) {
        this.supportedClouds = Output.all(values.asList())
    }

    /**
     * @param values List of all standard supported clouds.
     */
    @JvmName("bfkmbouongvpopos")
    public suspend fun supportedClouds(values: List<Output<StandardSupportedClouds>>) {
        this.supportedClouds = Output.all(values)
    }

    /**
     * @param value A list of key value pairs that describe the resource.
     */
    @JvmName("bcrbgvmghlaquomb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value category of the standard provided
     */
    @JvmName("rosyvuddfopcofxh")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value List of component objects containing component unique keys (such as assessment keys) to apply to standard scope.  Currently only supports assessment keys.
     */
    @JvmName("dawwfwiauygaxrix")
    public suspend fun components(`value`: List<StandardComponentPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.components = mapped
    }

    /**
     * @param argument List of component objects containing component unique keys (such as assessment keys) to apply to standard scope.  Currently only supports assessment keys.
     */
    @JvmName("ssioowmlmcwitxta")
    public suspend
    fun components(argument: List<suspend StandardComponentPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StandardComponentPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.components = mapped
    }

    /**
     * @param argument List of component objects containing component unique keys (such as assessment keys) to apply to standard scope.  Currently only supports assessment keys.
     */
    @JvmName("gkbwaxpxicuptpuo")
    public suspend fun components(
        vararg
        argument: suspend StandardComponentPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            StandardComponentPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.components = mapped
    }

    /**
     * @param argument List of component objects containing component unique keys (such as assessment keys) to apply to standard scope.  Currently only supports assessment keys.
     */
    @JvmName("rmxalgrppyvohtkq")
    public suspend
    fun components(argument: suspend StandardComponentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            StandardComponentPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.components = mapped
    }

    /**
     * @param values List of component objects containing component unique keys (such as assessment keys) to apply to standard scope.  Currently only supports assessment keys.
     */
    @JvmName("swsatkslcprbpeld")
    public suspend fun components(vararg values: StandardComponentPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.components = mapped
    }

    /**
     * @param value description of the standard
     */
    @JvmName("vqscvyxhsaloutoe")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value display name of the standard, equivalent to the standardId
     */
    @JvmName("tsisdwlkqajqcjrw")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Kind of the resource
     */
    @JvmName("rxnkejxqtftiixjp")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Location where the resource is stored
     */
    @JvmName("perhpddgbqyhgmpe")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("ejqmfjxcbkqbkmum")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Security Standard key - unique key for the standard type
     */
    @JvmName("moclmbnoxffgllwo")
    public suspend fun standardId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.standardId = mapped
    }

    /**
     * @param value List of all standard supported clouds.
     */
    @JvmName("vlkgbpnbliqlnmqy")
    public suspend fun supportedClouds(`value`: List<StandardSupportedClouds>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportedClouds = mapped
    }

    /**
     * @param values List of all standard supported clouds.
     */
    @JvmName("ckvnrutlvqsevkwh")
    public suspend fun supportedClouds(vararg values: StandardSupportedClouds) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.supportedClouds = mapped
    }

    /**
     * @param value A list of key value pairs that describe the resource.
     */
    @JvmName("tqygchvqbdvbqrqi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A list of key value pairs that describe the resource.
     */
    @JvmName("nqaqwpupcehchpio")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): StandardArgs = StandardArgs(
        category = category,
        components = components,
        description = description,
        displayName = displayName,
        kind = kind,
        location = location,
        resourceGroupName = resourceGroupName,
        standardId = standardId,
        supportedClouds = supportedClouds,
        tags = tags,
    )
}
