@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Whether or not to automatically install Azure Arc (hybrid compute) agents on machines
 */
public enum class AutoProvision(
    public val javaValue: com.pulumi.azurenative.security.enums.AutoProvision,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.AutoProvision> {
    /**
     * Install missing Azure Arc agents on machines automatically
     */
    On(com.pulumi.azurenative.security.enums.AutoProvision.On),

    /**
     * Do not install Azure Arc agent on the machines automatically
     */
    Off(com.pulumi.azurenative.security.enums.AutoProvision.Off),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.AutoProvision = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.AutoProvision):
            AutoProvision = AutoProvision.values().first { it.javaValue == javaType }
    }
}
