@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The multi cloud resource's cloud name.
 */
public enum class CloudName(
    public val javaValue: com.pulumi.azurenative.security.enums.CloudName,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.CloudName> {
    Azure(com.pulumi.azurenative.security.enums.CloudName.Azure),
    AWS(com.pulumi.azurenative.security.enums.CloudName.AWS),
    GCP(com.pulumi.azurenative.security.enums.CloudName.GCP),
    Github(com.pulumi.azurenative.security.enums.CloudName.Github),
    AzureDevOps(com.pulumi.azurenative.security.enums.CloudName.AzureDevOps),
    GitLab(com.pulumi.azurenative.security.enums.CloudName.GitLab),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.CloudName = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.CloudName): CloudName =
            CloudName.values().first { it.javaValue == javaType }
    }
}
