@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * If set to "False", it allows the descendants of this scope to override the pricing configuration set on this scope (allows setting inherited="False"). If set to "True", it prevents overrides and forces this pricing configuration on all the descendants of this scope. This field is only available for subscription-level pricing.
 */
public enum class Enforce(
    public val javaValue: com.pulumi.azurenative.security.enums.Enforce,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.Enforce> {
    /**
     * Allows the descendants of this scope to override the pricing configuration set on this scope (allows setting inherited="False")
     */
    False(com.pulumi.azurenative.security.enums.Enforce.False),

    /**
     * Prevents overrides and forces the current scope's pricing configuration to all descendants
     */
    True(com.pulumi.azurenative.security.enums.Enforce.True),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.Enforce = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.Enforce): Enforce =
            Enforce.values().first { it.javaValue == javaType }
    }
}
