@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * A valid event source type.
 */
public enum class EventSource(
    public val javaValue: com.pulumi.azurenative.security.enums.EventSource,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.EventSource> {
    Assessments(com.pulumi.azurenative.security.enums.EventSource.Assessments),
    AssessmentsSnapshot(com.pulumi.azurenative.security.enums.EventSource.AssessmentsSnapshot),
    SubAssessments(com.pulumi.azurenative.security.enums.EventSource.SubAssessments),
    SubAssessmentsSnapshot(com.pulumi.azurenative.security.enums.EventSource.SubAssessmentsSnapshot),
    Alerts(com.pulumi.azurenative.security.enums.EventSource.Alerts),
    SecureScores(com.pulumi.azurenative.security.enums.EventSource.SecureScores),
    SecureScoresSnapshot(com.pulumi.azurenative.security.enums.EventSource.SecureScoresSnapshot),
    SecureScoreControls(com.pulumi.azurenative.security.enums.EventSource.SecureScoreControls),
    SecureScoreControlsSnapshot(com.pulumi.azurenative.security.enums.EventSource.SecureScoreControlsSnapshot),
    RegulatoryComplianceAssessment(com.pulumi.azurenative.security.enums.EventSource.RegulatoryComplianceAssessment),
    RegulatoryComplianceAssessmentSnapshot(com.pulumi.azurenative.security.enums.EventSource.RegulatoryComplianceAssessmentSnapshot),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.EventSource = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.EventSource): EventSource =
            EventSource.values().first { it.javaValue == javaType }
    }
}
