@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The severity level of the assessment
 */
public enum class Severity(
    public val javaValue: com.pulumi.azurenative.security.enums.Severity,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.Severity> {
    Low(com.pulumi.azurenative.security.enums.Severity.Low),
    Medium(com.pulumi.azurenative.security.enums.Severity.Medium),
    High(com.pulumi.azurenative.security.enums.Severity.High),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.Severity = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.Severity): Severity =
            Severity.values().first { it.javaValue == javaType }
    }
}
