@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Relevant cloud for the custom assessment automation.
 */
public enum class SupportedCloudEnum(
    public val javaValue: com.pulumi.azurenative.security.enums.SupportedCloudEnum,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.SupportedCloudEnum> {
    AWS(com.pulumi.azurenative.security.enums.SupportedCloudEnum.AWS),
    GCP(com.pulumi.azurenative.security.enums.SupportedCloudEnum.GCP),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.SupportedCloudEnum = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.SupportedCloudEnum):
            SupportedCloudEnum = SupportedCloudEnum.values().first { it.javaValue == javaType }
    }
}
