@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.AllowlistCustomAlertRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A custom alert rule that checks if a value (depends on the custom alert type) is allowed.
 * @property allowlistValues The values to allow. The format of the values depends on the rule type.
 * @property isEnabled Status of the custom alert.
 * @property ruleType The type of the custom alert rule.
 * Expected value is 'AllowlistCustomAlertRule'.
 */
public data class AllowlistCustomAlertRuleArgs(
    public val allowlistValues: Output<List<String>>,
    public val isEnabled: Output<Boolean>,
    public val ruleType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.AllowlistCustomAlertRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.AllowlistCustomAlertRuleArgs =
        com.pulumi.azurenative.security.inputs.AllowlistCustomAlertRuleArgs.builder()
            .allowlistValues(allowlistValues.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .isEnabled(isEnabled.applyValue({ args0 -> args0 }))
            .ruleType(ruleType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AllowlistCustomAlertRuleArgs].
 */
@PulumiTagMarker
public class AllowlistCustomAlertRuleArgsBuilder internal constructor() {
    private var allowlistValues: Output<List<String>>? = null

    private var isEnabled: Output<Boolean>? = null

    private var ruleType: Output<String>? = null

    /**
     * @param value The values to allow. The format of the values depends on the rule type.
     */
    @JvmName("lhldhrlbajesycmc")
    public suspend fun allowlistValues(`value`: Output<List<String>>) {
        this.allowlistValues = value
    }

    @JvmName("upssgwrughxucpci")
    public suspend fun allowlistValues(vararg values: Output<String>) {
        this.allowlistValues = Output.all(values.asList())
    }

    /**
     * @param values The values to allow. The format of the values depends on the rule type.
     */
    @JvmName("tpwfcfpwlpqoaotl")
    public suspend fun allowlistValues(values: List<Output<String>>) {
        this.allowlistValues = Output.all(values)
    }

    /**
     * @param value Status of the custom alert.
     */
    @JvmName("pdjhjxkovlyldcgj")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value The type of the custom alert rule.
     * Expected value is 'AllowlistCustomAlertRule'.
     */
    @JvmName("fngktagxjatmslfp")
    public suspend fun ruleType(`value`: Output<String>) {
        this.ruleType = value
    }

    /**
     * @param value The values to allow. The format of the values depends on the rule type.
     */
    @JvmName("cfpwolfxcjxxcbbn")
    public suspend fun allowlistValues(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowlistValues = mapped
    }

    /**
     * @param values The values to allow. The format of the values depends on the rule type.
     */
    @JvmName("svwdcmtoqocwnpnf")
    public suspend fun allowlistValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowlistValues = mapped
    }

    /**
     * @param value Status of the custom alert.
     */
    @JvmName("lhltvfnrocdpogkr")
    public suspend fun isEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value The type of the custom alert rule.
     * Expected value is 'AllowlistCustomAlertRule'.
     */
    @JvmName("ogbfffbegyjcqyov")
    public suspend fun ruleType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    internal fun build(): AllowlistCustomAlertRuleArgs = AllowlistCustomAlertRuleArgs(
        allowlistValues = allowlistValues ?: throw PulumiNullFieldException("allowlistValues"),
        isEnabled = isEnabled ?: throw PulumiNullFieldException("isEnabled"),
        ruleType = ruleType ?: throw PulumiNullFieldException("ruleType"),
    )
}
