@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.AssignedStandardItemArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * describe the properties of a of a security standard object reference
 * @property id full resourceId of the Microsoft.Security/standard object
 */
public data class AssignedStandardItemArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.AssignedStandardItemArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.AssignedStandardItemArgs =
        com.pulumi.azurenative.security.inputs.AssignedStandardItemArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssignedStandardItemArgs].
 */
@PulumiTagMarker
public class AssignedStandardItemArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value full resourceId of the Microsoft.Security/standard object
     */
    @JvmName("ddvnxrhsgwmfloaf")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value full resourceId of the Microsoft.Security/standard object
     */
    @JvmName("twacdiavvvujkwxv")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): AssignedStandardItemArgs = AssignedStandardItemArgs(
        id = id,
    )
}
