@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.AutomationRuleSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A rule set which evaluates all its rules upon an event interception. Only when all the included rules in the rule set will be evaluated as 'true', will the event trigger the defined actions.
 * @property rules
 */
public data class AutomationRuleSetArgs(
    public val rules: Output<List<AutomationTriggeringRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.AutomationRuleSetArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.AutomationRuleSetArgs =
        com.pulumi.azurenative.security.inputs.AutomationRuleSetArgs.builder()
            .rules(
                rules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AutomationRuleSetArgs].
 */
@PulumiTagMarker
public class AutomationRuleSetArgsBuilder internal constructor() {
    private var rules: Output<List<AutomationTriggeringRuleArgs>>? = null

    /**
     * @param value
     */
    @JvmName("oomrbsbskrnhwfkd")
    public suspend fun rules(`value`: Output<List<AutomationTriggeringRuleArgs>>) {
        this.rules = value
    }

    @JvmName("xjxqmdnuklucrdxg")
    public suspend fun rules(vararg values: Output<AutomationTriggeringRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("viskwnsybnkxyaob")
    public suspend fun rules(values: List<Output<AutomationTriggeringRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("mxnwyynvfgqwrwya")
    public suspend fun rules(`value`: List<AutomationTriggeringRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("yukptlsvwqyeumet")
    public suspend fun rules(argument: List<suspend AutomationTriggeringRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationTriggeringRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("fcplsfqtgcgoeein")
    public suspend fun rules(
        vararg
        argument: suspend AutomationTriggeringRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AutomationTriggeringRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lkbivstvpnpclsrl")
    public suspend fun rules(argument: suspend AutomationTriggeringRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationTriggeringRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values
     */
    @JvmName("dlxdlghbngokasmn")
    public suspend fun rules(vararg values: AutomationTriggeringRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): AutomationRuleSetArgs = AutomationRuleSetArgs(
        rules = rules,
    )
}
