@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.AwAssumeRoleAuthenticationDetailsPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * AWS cloud account connector based assume role, the role enables delegating access to your AWS resources. The role is composed of role Amazon Resource Name (ARN) and external ID. For more details, refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user.html">Creating a Role to Delegate Permissions to an IAM User (write only)</a>
 * @property authenticationType Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials.
 * Expected value is 'awsAssumeRole'.
 * @property awsAssumeRoleArn Assumed role ID is an identifier that you can use to create temporary security credentials.
 * @property awsExternalId A unique identifier that is required when you assume a role in another account.
 */
public data class AwAssumeRoleAuthenticationDetailsPropertiesArgs(
    public val authenticationType: Output<String>,
    public val awsAssumeRoleArn: Output<String>,
    public val awsExternalId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.AwAssumeRoleAuthenticationDetailsPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.AwAssumeRoleAuthenticationDetailsPropertiesArgs =
        com.pulumi.azurenative.security.inputs.AwAssumeRoleAuthenticationDetailsPropertiesArgs.builder()
            .authenticationType(authenticationType.applyValue({ args0 -> args0 }))
            .awsAssumeRoleArn(awsAssumeRoleArn.applyValue({ args0 -> args0 }))
            .awsExternalId(awsExternalId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AwAssumeRoleAuthenticationDetailsPropertiesArgs].
 */
@PulumiTagMarker
public class AwAssumeRoleAuthenticationDetailsPropertiesArgsBuilder internal constructor() {
    private var authenticationType: Output<String>? = null

    private var awsAssumeRoleArn: Output<String>? = null

    private var awsExternalId: Output<String>? = null

    /**
     * @param value Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials.
     * Expected value is 'awsAssumeRole'.
     */
    @JvmName("myncdxqjssjxesbf")
    public suspend fun authenticationType(`value`: Output<String>) {
        this.authenticationType = value
    }

    /**
     * @param value Assumed role ID is an identifier that you can use to create temporary security credentials.
     */
    @JvmName("essvicicrvtkkjed")
    public suspend fun awsAssumeRoleArn(`value`: Output<String>) {
        this.awsAssumeRoleArn = value
    }

    /**
     * @param value A unique identifier that is required when you assume a role in another account.
     */
    @JvmName("snqsorqqlegihhns")
    public suspend fun awsExternalId(`value`: Output<String>) {
        this.awsExternalId = value
    }

    /**
     * @param value Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials.
     * Expected value is 'awsAssumeRole'.
     */
    @JvmName("yoptnlndcuvolrlc")
    public suspend fun authenticationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Assumed role ID is an identifier that you can use to create temporary security credentials.
     */
    @JvmName("uvnttynquaphipuc")
    public suspend fun awsAssumeRoleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.awsAssumeRoleArn = mapped
    }

    /**
     * @param value A unique identifier that is required when you assume a role in another account.
     */
    @JvmName("yftyoedgdalogkvw")
    public suspend fun awsExternalId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.awsExternalId = mapped
    }

    internal fun build(): AwAssumeRoleAuthenticationDetailsPropertiesArgs =
        AwAssumeRoleAuthenticationDetailsPropertiesArgs(
            authenticationType = authenticationType ?: throw PulumiNullFieldException("authenticationType"),
            awsAssumeRoleArn = awsAssumeRoleArn ?: throw PulumiNullFieldException("awsAssumeRoleArn"),
            awsExternalId = awsExternalId ?: throw PulumiNullFieldException("awsExternalId"),
        )
}
