@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.AwsEnvironmentDataArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The AWS connector environment data
 * @property environmentType The type of the environment data.
 * Expected value is 'AwsAccount'.
 * @property organizationalData The AWS account's organizational data
 * @property regions list of regions to scan
 */
public data class AwsEnvironmentDataArgs(
    public val environmentType: Output<String>,
    public val organizationalData:
    Output<Either<AwsOrganizationalDataMasterArgs, AwsOrganizationalDataMemberArgs>>? = null,
    public val regions: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.AwsEnvironmentDataArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.AwsEnvironmentDataArgs =
        com.pulumi.azurenative.security.inputs.AwsEnvironmentDataArgs.builder()
            .environmentType(environmentType.applyValue({ args0 -> args0 }))
            .organizationalData(
                organizationalData?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .regions(regions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AwsEnvironmentDataArgs].
 */
@PulumiTagMarker
public class AwsEnvironmentDataArgsBuilder internal constructor() {
    private var environmentType: Output<String>? = null

    private var organizationalData:
        Output<Either<AwsOrganizationalDataMasterArgs, AwsOrganizationalDataMemberArgs>>? = null

    private var regions: Output<List<String>>? = null

    /**
     * @param value The type of the environment data.
     * Expected value is 'AwsAccount'.
     */
    @JvmName("cpqepwwggtjxddho")
    public suspend fun environmentType(`value`: Output<String>) {
        this.environmentType = value
    }

    /**
     * @param value The AWS account's organizational data
     */
    @JvmName("jqdofhmmsurttrwy")
    public suspend
    fun organizationalData(`value`: Output<Either<AwsOrganizationalDataMasterArgs, AwsOrganizationalDataMemberArgs>>) {
        this.organizationalData = value
    }

    /**
     * @param value list of regions to scan
     */
    @JvmName("mybecchefkqnyrje")
    public suspend fun regions(`value`: Output<List<String>>) {
        this.regions = value
    }

    @JvmName("ruqnqqfosjtoksym")
    public suspend fun regions(vararg values: Output<String>) {
        this.regions = Output.all(values.asList())
    }

    /**
     * @param values list of regions to scan
     */
    @JvmName("htdbiqgypgtstcrw")
    public suspend fun regions(values: List<Output<String>>) {
        this.regions = Output.all(values)
    }

    /**
     * @param value The type of the environment data.
     * Expected value is 'AwsAccount'.
     */
    @JvmName("yfiuusaujergbows")
    public suspend fun environmentType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentType = mapped
    }

    /**
     * @param value The AWS account's organizational data
     */
    @JvmName("qydceeppgcgvrwok")
    public suspend
    fun organizationalData(`value`: Either<AwsOrganizationalDataMasterArgs, AwsOrganizationalDataMemberArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationalData = mapped
    }

    /**
     * @param value The AWS account's organizational data
     */
    @JvmName("sttfaieyfkaobypv")
    public fun organizationalData(`value`: AwsOrganizationalDataMasterArgs) {
        val toBeMapped = Either.ofLeft<AwsOrganizationalDataMasterArgs,
            AwsOrganizationalDataMemberArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.organizationalData = mapped
    }

    /**
     * @param value The AWS account's organizational data
     */
    @JvmName("qeyrjaydidjutrcr")
    public fun organizationalData(`value`: AwsOrganizationalDataMemberArgs) {
        val toBeMapped = Either.ofRight<AwsOrganizationalDataMasterArgs,
            AwsOrganizationalDataMemberArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.organizationalData = mapped
    }

    /**
     * @param value list of regions to scan
     */
    @JvmName("rmvtccfvgugyjinm")
    public suspend fun regions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param values list of regions to scan
     */
    @JvmName("gvfxnoevqcfuexca")
    public suspend fun regions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    internal fun build(): AwsEnvironmentDataArgs = AwsEnvironmentDataArgs(
        environmentType = environmentType ?: throw PulumiNullFieldException("environmentType"),
        organizationalData = organizationalData,
        regions = regions,
    )
}
