@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.CspmMonitorAzureDevOpsOfferingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The CSPM monitoring for AzureDevOps offering
 * @property offeringType The type of the security offering.
 * Expected value is 'CspmMonitorAzureDevOps'.
 */
public data class CspmMonitorAzureDevOpsOfferingArgs(
    public val offeringType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.CspmMonitorAzureDevOpsOfferingArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.CspmMonitorAzureDevOpsOfferingArgs =
        com.pulumi.azurenative.security.inputs.CspmMonitorAzureDevOpsOfferingArgs.builder()
            .offeringType(offeringType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CspmMonitorAzureDevOpsOfferingArgs].
 */
@PulumiTagMarker
public class CspmMonitorAzureDevOpsOfferingArgsBuilder internal constructor() {
    private var offeringType: Output<String>? = null

    /**
     * @param value The type of the security offering.
     * Expected value is 'CspmMonitorAzureDevOps'.
     */
    @JvmName("rnpjqyrmqsjodwhu")
    public suspend fun offeringType(`value`: Output<String>) {
        this.offeringType = value
    }

    /**
     * @param value The type of the security offering.
     * Expected value is 'CspmMonitorAzureDevOps'.
     */
    @JvmName("smcsjvktvxpohyus")
    public suspend fun offeringType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offeringType = mapped
    }

    internal fun build(): CspmMonitorAzureDevOpsOfferingArgs = CspmMonitorAzureDevOpsOfferingArgs(
        offeringType = offeringType ?: throw PulumiNullFieldException("offeringType"),
    )
}
