@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.CspmMonitorGitLabOfferingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The CSPM (Cloud security posture management) monitoring for gitlab offering
 * @property offeringType The type of the security offering.
 * Expected value is 'CspmMonitorGitLab'.
 */
public data class CspmMonitorGitLabOfferingArgs(
    public val offeringType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.CspmMonitorGitLabOfferingArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.CspmMonitorGitLabOfferingArgs =
        com.pulumi.azurenative.security.inputs.CspmMonitorGitLabOfferingArgs.builder()
            .offeringType(offeringType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CspmMonitorGitLabOfferingArgs].
 */
@PulumiTagMarker
public class CspmMonitorGitLabOfferingArgsBuilder internal constructor() {
    private var offeringType: Output<String>? = null

    /**
     * @param value The type of the security offering.
     * Expected value is 'CspmMonitorGitLab'.
     */
    @JvmName("aksssjtprawtdmlp")
    public suspend fun offeringType(`value`: Output<String>) {
        this.offeringType = value
    }

    /**
     * @param value The type of the security offering.
     * Expected value is 'CspmMonitorGitLab'.
     */
    @JvmName("fhectoborxcosjiq")
    public suspend fun offeringType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offeringType = mapped
    }

    internal fun build(): CspmMonitorGitLabOfferingArgs = CspmMonitorGitLabOfferingArgs(
        offeringType = offeringType ?: throw PulumiNullFieldException("offeringType"),
    )
}
