@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.CspmMonitorGithubOfferingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The CSPM monitoring for github offering
 * @property offeringType The type of the security offering.
 * Expected value is 'CspmMonitorGithub'.
 */
public data class CspmMonitorGithubOfferingArgs(
    public val offeringType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.CspmMonitorGithubOfferingArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.CspmMonitorGithubOfferingArgs =
        com.pulumi.azurenative.security.inputs.CspmMonitorGithubOfferingArgs.builder()
            .offeringType(offeringType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CspmMonitorGithubOfferingArgs].
 */
@PulumiTagMarker
public class CspmMonitorGithubOfferingArgsBuilder internal constructor() {
    private var offeringType: Output<String>? = null

    /**
     * @param value The type of the security offering.
     * Expected value is 'CspmMonitorGithub'.
     */
    @JvmName("xstoadtaihapynrt")
    public suspend fun offeringType(`value`: Output<String>) {
        this.offeringType = value
    }

    /**
     * @param value The type of the security offering.
     * Expected value is 'CspmMonitorGithub'.
     */
    @JvmName("exgkfmrpytxwaayx")
    public suspend fun offeringType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offeringType = mapped
    }

    internal fun build(): CspmMonitorGithubOfferingArgs = CspmMonitorGithubOfferingArgs(
        offeringType = offeringType ?: throw PulumiNullFieldException("offeringType"),
    )
}
