@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderCspmAwsOfferingDataSensitivityDiscoveryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Microsoft Defender Data Sensitivity discovery configuration
 * @property cloudRoleArn The cloud role ARN in AWS for this feature
 * @property enabled Is Microsoft Defender Data Sensitivity discovery enabled
 */
public data class DefenderCspmAwsOfferingDataSensitivityDiscoveryArgs(
    public val cloudRoleArn: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderCspmAwsOfferingDataSensitivityDiscoveryArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.DefenderCspmAwsOfferingDataSensitivityDiscoveryArgs =
        com.pulumi.azurenative.security.inputs.DefenderCspmAwsOfferingDataSensitivityDiscoveryArgs.builder()
            .cloudRoleArn(cloudRoleArn?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderCspmAwsOfferingDataSensitivityDiscoveryArgs].
 */
@PulumiTagMarker
public class DefenderCspmAwsOfferingDataSensitivityDiscoveryArgsBuilder internal constructor() {
    private var cloudRoleArn: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value The cloud role ARN in AWS for this feature
     */
    @JvmName("kllxlvstqmqhqntb")
    public suspend fun cloudRoleArn(`value`: Output<String>) {
        this.cloudRoleArn = value
    }

    /**
     * @param value Is Microsoft Defender Data Sensitivity discovery enabled
     */
    @JvmName("ihjtudwbdkofmcoy")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The cloud role ARN in AWS for this feature
     */
    @JvmName("mvebwoligesvbyte")
    public suspend fun cloudRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudRoleArn = mapped
    }

    /**
     * @param value Is Microsoft Defender Data Sensitivity discovery enabled
     */
    @JvmName("xmdisdbxlykdxenr")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): DefenderCspmAwsOfferingDataSensitivityDiscoveryArgs =
        DefenderCspmAwsOfferingDataSensitivityDiscoveryArgs(
            cloudRoleArn = cloudRoleArn,
            enabled = enabled,
        )
}
