@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderFoDatabasesAwsOfferingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Defender for Databases AWS offering
 * @property arcAutoProvisioning The ARC autoprovisioning configuration
 * @property databasesDspm The databases data security posture management (DSPM) configuration
 * @property offeringType The type of the security offering.
 * Expected value is 'DefenderForDatabasesAws'.
 * @property rds The RDS configuration
 */
public data class DefenderFoDatabasesAwsOfferingArgs(
    public val arcAutoProvisioning: Output<DefenderFoDatabasesAwsOfferingArcAutoProvisioningArgs>? =
        null,
    public val databasesDspm: Output<DefenderFoDatabasesAwsOfferingDatabasesDspmArgs>? = null,
    public val offeringType: Output<String>,
    public val rds: Output<DefenderFoDatabasesAwsOfferingRdsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderFoDatabasesAwsOfferingArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.DefenderFoDatabasesAwsOfferingArgs =
        com.pulumi.azurenative.security.inputs.DefenderFoDatabasesAwsOfferingArgs.builder()
            .arcAutoProvisioning(
                arcAutoProvisioning?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .databasesDspm(databasesDspm?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .offeringType(offeringType.applyValue({ args0 -> args0 }))
            .rds(rds?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DefenderFoDatabasesAwsOfferingArgs].
 */
@PulumiTagMarker
public class DefenderFoDatabasesAwsOfferingArgsBuilder internal constructor() {
    private var arcAutoProvisioning: Output<DefenderFoDatabasesAwsOfferingArcAutoProvisioningArgs>? =
        null

    private var databasesDspm: Output<DefenderFoDatabasesAwsOfferingDatabasesDspmArgs>? = null

    private var offeringType: Output<String>? = null

    private var rds: Output<DefenderFoDatabasesAwsOfferingRdsArgs>? = null

    /**
     * @param value The ARC autoprovisioning configuration
     */
    @JvmName("kawtppbyqpfwxbyq")
    public suspend
    fun arcAutoProvisioning(`value`: Output<DefenderFoDatabasesAwsOfferingArcAutoProvisioningArgs>) {
        this.arcAutoProvisioning = value
    }

    /**
     * @param value The databases data security posture management (DSPM) configuration
     */
    @JvmName("tafnchgtvwakvswg")
    public suspend
    fun databasesDspm(`value`: Output<DefenderFoDatabasesAwsOfferingDatabasesDspmArgs>) {
        this.databasesDspm = value
    }

    /**
     * @param value The type of the security offering.
     * Expected value is 'DefenderForDatabasesAws'.
     */
    @JvmName("bbchhdmynkxgnpvx")
    public suspend fun offeringType(`value`: Output<String>) {
        this.offeringType = value
    }

    /**
     * @param value The RDS configuration
     */
    @JvmName("yvjepaksumqepjqv")
    public suspend fun rds(`value`: Output<DefenderFoDatabasesAwsOfferingRdsArgs>) {
        this.rds = value
    }

    /**
     * @param value The ARC autoprovisioning configuration
     */
    @JvmName("scwmpchamuuhwdyy")
    public suspend
    fun arcAutoProvisioning(`value`: DefenderFoDatabasesAwsOfferingArcAutoProvisioningArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arcAutoProvisioning = mapped
    }

    /**
     * @param argument The ARC autoprovisioning configuration
     */
    @JvmName("ywkqjrhtormjqlks")
    public suspend
    fun arcAutoProvisioning(argument: suspend DefenderFoDatabasesAwsOfferingArcAutoProvisioningArgsBuilder.() -> Unit) {
        val toBeMapped = DefenderFoDatabasesAwsOfferingArcAutoProvisioningArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.arcAutoProvisioning = mapped
    }

    /**
     * @param value The databases data security posture management (DSPM) configuration
     */
    @JvmName("howluwxhtbbyqfje")
    public suspend fun databasesDspm(`value`: DefenderFoDatabasesAwsOfferingDatabasesDspmArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databasesDspm = mapped
    }

    /**
     * @param argument The databases data security posture management (DSPM) configuration
     */
    @JvmName("wvsksljbrxnqsdym")
    public suspend
    fun databasesDspm(argument: suspend DefenderFoDatabasesAwsOfferingDatabasesDspmArgsBuilder.() -> Unit) {
        val toBeMapped = DefenderFoDatabasesAwsOfferingDatabasesDspmArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.databasesDspm = mapped
    }

    /**
     * @param value The type of the security offering.
     * Expected value is 'DefenderForDatabasesAws'.
     */
    @JvmName("hqpumynciocoggce")
    public suspend fun offeringType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offeringType = mapped
    }

    /**
     * @param value The RDS configuration
     */
    @JvmName("hekwwmofdexrkekf")
    public suspend fun rds(`value`: DefenderFoDatabasesAwsOfferingRdsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rds = mapped
    }

    /**
     * @param argument The RDS configuration
     */
    @JvmName("knksgglddxfjfcpt")
    public suspend
    fun rds(argument: suspend DefenderFoDatabasesAwsOfferingRdsArgsBuilder.() -> Unit) {
        val toBeMapped = DefenderFoDatabasesAwsOfferingRdsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rds = mapped
    }

    internal fun build(): DefenderFoDatabasesAwsOfferingArgs = DefenderFoDatabasesAwsOfferingArgs(
        arcAutoProvisioning = arcAutoProvisioning,
        databasesDspm = databasesDspm,
        offeringType = offeringType ?: throw PulumiNullFieldException("offeringType"),
        rds = rds,
    )
}
