@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The container vulnerability assessment configuration
 * @property cloudRoleArn The cloud role ARN in AWS for this feature
 */
public data class DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentArgs(
    public val cloudRoleArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentArgs =
        com.pulumi.azurenative.security.inputs.DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentArgs.builder()
            .cloudRoleArn(cloudRoleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentArgs].
 */
@PulumiTagMarker
public class DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentArgsBuilder internal
constructor() {
    private var cloudRoleArn: Output<String>? = null

    /**
     * @param value The cloud role ARN in AWS for this feature
     */
    @JvmName("qbqoaamsprtcxave")
    public suspend fun cloudRoleArn(`value`: Output<String>) {
        this.cloudRoleArn = value
    }

    /**
     * @param value The cloud role ARN in AWS for this feature
     */
    @JvmName("fwshyajmbjjlqljx")
    public suspend fun cloudRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudRoleArn = mapped
    }

    internal fun build(): DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentArgs =
        DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentArgs(
            cloudRoleArn = cloudRoleArn,
        )
}
