@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTaskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The container vulnerability assessment task configuration
 * @property cloudRoleArn The cloud role ARN in AWS for this feature
 */
public data class DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTaskArgs(
    public val cloudRoleArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTaskArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTaskArgs =
        com.pulumi.azurenative.security.inputs.DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTaskArgs.builder()
            .cloudRoleArn(cloudRoleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTaskArgs].
 */
@PulumiTagMarker
public class DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTaskArgsBuilder
internal constructor() {
    private var cloudRoleArn: Output<String>? = null

    /**
     * @param value The cloud role ARN in AWS for this feature
     */
    @JvmName("kqgsitdtfxduymkl")
    public suspend fun cloudRoleArn(`value`: Output<String>) {
        this.cloudRoleArn = value
    }

    /**
     * @param value The cloud role ARN in AWS for this feature
     */
    @JvmName("fsssecyphshwllvl")
    public suspend fun cloudRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudRoleArn = mapped
    }

    internal fun build(): DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTaskArgs =
        DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTaskArgs(
            cloudRoleArn = cloudRoleArn,
        )
}
