@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForContainersAwsOfferingKubernetesScubaReaderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The kubernetes to scuba connection configuration
 * @property cloudRoleArn The cloud role ARN in AWS for this feature used for reading data
 */
public data class DefenderForContainersAwsOfferingKubernetesScubaReaderArgs(
    public val cloudRoleArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForContainersAwsOfferingKubernetesScubaReaderArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.DefenderForContainersAwsOfferingKubernetesScubaReaderArgs =
        com.pulumi.azurenative.security.inputs.DefenderForContainersAwsOfferingKubernetesScubaReaderArgs.builder()
            .cloudRoleArn(cloudRoleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderForContainersAwsOfferingKubernetesScubaReaderArgs].
 */
@PulumiTagMarker
public class DefenderForContainersAwsOfferingKubernetesScubaReaderArgsBuilder internal constructor() {
    private var cloudRoleArn: Output<String>? = null

    /**
     * @param value The cloud role ARN in AWS for this feature used for reading data
     */
    @JvmName("pwnqwdlnpgbuscfd")
    public suspend fun cloudRoleArn(`value`: Output<String>) {
        this.cloudRoleArn = value
    }

    /**
     * @param value The cloud role ARN in AWS for this feature used for reading data
     */
    @JvmName("likricgtcudouvvv")
    public suspend fun cloudRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudRoleArn = mapped
    }

    internal fun build(): DefenderForContainersAwsOfferingKubernetesScubaReaderArgs =
        DefenderForContainersAwsOfferingKubernetesScubaReaderArgs(
            cloudRoleArn = cloudRoleArn,
        )
}
