@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingDefenderForServersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Defender for servers connection configuration
 * @property cloudRoleArn The cloud role ARN in AWS for this feature
 */
public data class DefenderForServersAwsOfferingDefenderForServersArgs(
    public val cloudRoleArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingDefenderForServersArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingDefenderForServersArgs =
        com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingDefenderForServersArgs.builder()
            .cloudRoleArn(cloudRoleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderForServersAwsOfferingDefenderForServersArgs].
 */
@PulumiTagMarker
public class DefenderForServersAwsOfferingDefenderForServersArgsBuilder internal constructor() {
    private var cloudRoleArn: Output<String>? = null

    /**
     * @param value The cloud role ARN in AWS for this feature
     */
    @JvmName("xiemvilsmgwdkaqe")
    public suspend fun cloudRoleArn(`value`: Output<String>) {
        this.cloudRoleArn = value
    }

    /**
     * @param value The cloud role ARN in AWS for this feature
     */
    @JvmName("trmmvfjxaymoybig")
    public suspend fun cloudRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudRoleArn = mapped
    }

    internal fun build(): DefenderForServersAwsOfferingDefenderForServersArgs =
        DefenderForServersAwsOfferingDefenderForServersArgs(
            cloudRoleArn = cloudRoleArn,
        )
}
