@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DenylistCustomAlertRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A custom alert rule that checks if a value (depends on the custom alert type) is denied.
 * @property denylistValues The values to deny. The format of the values depends on the rule type.
 * @property isEnabled Status of the custom alert.
 * @property ruleType The type of the custom alert rule.
 * Expected value is 'DenylistCustomAlertRule'.
 */
public data class DenylistCustomAlertRuleArgs(
    public val denylistValues: Output<List<String>>,
    public val isEnabled: Output<Boolean>,
    public val ruleType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.DenylistCustomAlertRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.DenylistCustomAlertRuleArgs =
        com.pulumi.azurenative.security.inputs.DenylistCustomAlertRuleArgs.builder()
            .denylistValues(denylistValues.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .isEnabled(isEnabled.applyValue({ args0 -> args0 }))
            .ruleType(ruleType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DenylistCustomAlertRuleArgs].
 */
@PulumiTagMarker
public class DenylistCustomAlertRuleArgsBuilder internal constructor() {
    private var denylistValues: Output<List<String>>? = null

    private var isEnabled: Output<Boolean>? = null

    private var ruleType: Output<String>? = null

    /**
     * @param value The values to deny. The format of the values depends on the rule type.
     */
    @JvmName("jrfgmllaxngtefrd")
    public suspend fun denylistValues(`value`: Output<List<String>>) {
        this.denylistValues = value
    }

    @JvmName("xwqfbwudaipxxudu")
    public suspend fun denylistValues(vararg values: Output<String>) {
        this.denylistValues = Output.all(values.asList())
    }

    /**
     * @param values The values to deny. The format of the values depends on the rule type.
     */
    @JvmName("scptoksrdletvodg")
    public suspend fun denylistValues(values: List<Output<String>>) {
        this.denylistValues = Output.all(values)
    }

    /**
     * @param value Status of the custom alert.
     */
    @JvmName("cnjrtvfbsvfmiswj")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value The type of the custom alert rule.
     * Expected value is 'DenylistCustomAlertRule'.
     */
    @JvmName("kfjcortiheouxpbf")
    public suspend fun ruleType(`value`: Output<String>) {
        this.ruleType = value
    }

    /**
     * @param value The values to deny. The format of the values depends on the rule type.
     */
    @JvmName("jqvysulavboueojy")
    public suspend fun denylistValues(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.denylistValues = mapped
    }

    /**
     * @param values The values to deny. The format of the values depends on the rule type.
     */
    @JvmName("abuifthjsxrujmui")
    public suspend fun denylistValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.denylistValues = mapped
    }

    /**
     * @param value Status of the custom alert.
     */
    @JvmName("wrpqgfiabvbruldv")
    public suspend fun isEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value The type of the custom alert rule.
     * Expected value is 'DenylistCustomAlertRule'.
     */
    @JvmName("bxrpbbrcotkoqabp")
    public suspend fun ruleType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    internal fun build(): DenylistCustomAlertRuleArgs = DenylistCustomAlertRuleArgs(
        denylistValues = denylistValues ?: throw PulumiNullFieldException("denylistValues"),
        isEnabled = isEnabled ?: throw PulumiNullFieldException("isEnabled"),
        ruleType = ruleType ?: throw PulumiNullFieldException("ruleType"),
    )
}
