@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DevOpsConfigurationPropertiesArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.AutoDiscovery
import com.pulumi.azurenative.security.kotlin.enums.DevOpsProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * DevOps Configuration properties.
 * @property authorization Authorization payload.
 * @property autoDiscovery AutoDiscovery states.
 * @property provisioningState The provisioning state of the resource.
 * Pending - Provisioning pending.
 * Failed - Provisioning failed.
 * Succeeded - Successful provisioning.
 * Canceled - Provisioning canceled.
 * PendingDeletion - Deletion pending.
 * DeletionSuccess - Deletion successful.
 * DeletionFailure - Deletion failure.
 * @property topLevelInventoryList List of top-level inventory to select when AutoDiscovery is disabled.
 * This field is ignored when AutoDiscovery is enabled.
 */
public data class DevOpsConfigurationPropertiesArgs(
    public val authorization: Output<AuthorizationArgs>? = null,
    public val autoDiscovery: Output<Either<String, AutoDiscovery>>? = null,
    public val provisioningState: Output<Either<String, DevOpsProvisioningState>>? = null,
    public val topLevelInventoryList: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.DevOpsConfigurationPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.DevOpsConfigurationPropertiesArgs =
        com.pulumi.azurenative.security.inputs.DevOpsConfigurationPropertiesArgs.builder()
            .authorization(authorization?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .autoDiscovery(
                autoDiscovery?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .topLevelInventoryList(
                topLevelInventoryList?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [DevOpsConfigurationPropertiesArgs].
 */
@PulumiTagMarker
public class DevOpsConfigurationPropertiesArgsBuilder internal constructor() {
    private var authorization: Output<AuthorizationArgs>? = null

    private var autoDiscovery: Output<Either<String, AutoDiscovery>>? = null

    private var provisioningState: Output<Either<String, DevOpsProvisioningState>>? = null

    private var topLevelInventoryList: Output<List<String>>? = null

    /**
     * @param value Authorization payload.
     */
    @JvmName("mrcfjmeqcsqfvhhf")
    public suspend fun authorization(`value`: Output<AuthorizationArgs>) {
        this.authorization = value
    }

    /**
     * @param value AutoDiscovery states.
     */
    @JvmName("ltehswrtbtrkkskj")
    public suspend fun autoDiscovery(`value`: Output<Either<String, AutoDiscovery>>) {
        this.autoDiscovery = value
    }

    /**
     * @param value The provisioning state of the resource.
     * Pending - Provisioning pending.
     * Failed - Provisioning failed.
     * Succeeded - Successful provisioning.
     * Canceled - Provisioning canceled.
     * PendingDeletion - Deletion pending.
     * DeletionSuccess - Deletion successful.
     * DeletionFailure - Deletion failure.
     */
    @JvmName("qvtfofqfetlrckwy")
    public suspend fun provisioningState(`value`: Output<Either<String, DevOpsProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value List of top-level inventory to select when AutoDiscovery is disabled.
     * This field is ignored when AutoDiscovery is enabled.
     */
    @JvmName("pjncnqgcfuxtwgkf")
    public suspend fun topLevelInventoryList(`value`: Output<List<String>>) {
        this.topLevelInventoryList = value
    }

    @JvmName("bikfgfklknwjeuab")
    public suspend fun topLevelInventoryList(vararg values: Output<String>) {
        this.topLevelInventoryList = Output.all(values.asList())
    }

    /**
     * @param values List of top-level inventory to select when AutoDiscovery is disabled.
     * This field is ignored when AutoDiscovery is enabled.
     */
    @JvmName("cbgxohlmlhsfnbym")
    public suspend fun topLevelInventoryList(values: List<Output<String>>) {
        this.topLevelInventoryList = Output.all(values)
    }

    /**
     * @param value Authorization payload.
     */
    @JvmName("ujhwarlopqdtcagg")
    public suspend fun authorization(`value`: AuthorizationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorization = mapped
    }

    /**
     * @param argument Authorization payload.
     */
    @JvmName("cjbqnodpabrcbfod")
    public suspend fun authorization(argument: suspend AuthorizationArgsBuilder.() -> Unit) {
        val toBeMapped = AuthorizationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.authorization = mapped
    }

    /**
     * @param value AutoDiscovery states.
     */
    @JvmName("apclbrgakxwwdekx")
    public suspend fun autoDiscovery(`value`: Either<String, AutoDiscovery>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoDiscovery = mapped
    }

    /**
     * @param value AutoDiscovery states.
     */
    @JvmName("uqulonqscwtxmfuw")
    public fun autoDiscovery(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AutoDiscovery>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoDiscovery = mapped
    }

    /**
     * @param value AutoDiscovery states.
     */
    @JvmName("ijaxsxkwoyxlmngp")
    public fun autoDiscovery(`value`: AutoDiscovery) {
        val toBeMapped = Either.ofRight<String, AutoDiscovery>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoDiscovery = mapped
    }

    /**
     * @param value The provisioning state of the resource.
     * Pending - Provisioning pending.
     * Failed - Provisioning failed.
     * Succeeded - Successful provisioning.
     * Canceled - Provisioning canceled.
     * PendingDeletion - Deletion pending.
     * DeletionSuccess - Deletion successful.
     * DeletionFailure - Deletion failure.
     */
    @JvmName("gjybhdecwrhmgiua")
    public suspend fun provisioningState(`value`: Either<String, DevOpsProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The provisioning state of the resource.
     * Pending - Provisioning pending.
     * Failed - Provisioning failed.
     * Succeeded - Successful provisioning.
     * Canceled - Provisioning canceled.
     * PendingDeletion - Deletion pending.
     * DeletionSuccess - Deletion successful.
     * DeletionFailure - Deletion failure.
     */
    @JvmName("ycbteodltksyqjft")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DevOpsProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The provisioning state of the resource.
     * Pending - Provisioning pending.
     * Failed - Provisioning failed.
     * Succeeded - Successful provisioning.
     * Canceled - Provisioning canceled.
     * PendingDeletion - Deletion pending.
     * DeletionSuccess - Deletion successful.
     * DeletionFailure - Deletion failure.
     */
    @JvmName("mdlpkbsxfamftmtf")
    public fun provisioningState(`value`: DevOpsProvisioningState) {
        val toBeMapped = Either.ofRight<String, DevOpsProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value List of top-level inventory to select when AutoDiscovery is disabled.
     * This field is ignored when AutoDiscovery is enabled.
     */
    @JvmName("tojeacnybyhclfvg")
    public suspend fun topLevelInventoryList(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topLevelInventoryList = mapped
    }

    /**
     * @param values List of top-level inventory to select when AutoDiscovery is disabled.
     * This field is ignored when AutoDiscovery is enabled.
     */
    @JvmName("lppeusmlabbhvhvx")
    public suspend fun topLevelInventoryList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topLevelInventoryList = mapped
    }

    internal fun build(): DevOpsConfigurationPropertiesArgs = DevOpsConfigurationPropertiesArgs(
        authorization = authorization,
        autoDiscovery = autoDiscovery,
        provisioningState = provisioningState,
        topLevelInventoryList = topLevelInventoryList,
    )
}
