@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GcpOrganizationalDataMemberArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The gcpOrganization data for the member account
 * @property managementProjectNumber The GCP management project number from organizational onboarding
 * @property organizationMembershipType The multi cloud account's membership type in the organization
 * Expected value is 'Member'.
 * @property parentHierarchyId If the multi cloud account is not of membership type organization, this will be the ID of the project's parent
 */
public data class GcpOrganizationalDataMemberArgs(
    public val managementProjectNumber: Output<String>? = null,
    public val organizationMembershipType: Output<String>,
    public val parentHierarchyId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GcpOrganizationalDataMemberArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GcpOrganizationalDataMemberArgs =
        com.pulumi.azurenative.security.inputs.GcpOrganizationalDataMemberArgs.builder()
            .managementProjectNumber(managementProjectNumber?.applyValue({ args0 -> args0 }))
            .organizationMembershipType(organizationMembershipType.applyValue({ args0 -> args0 }))
            .parentHierarchyId(parentHierarchyId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GcpOrganizationalDataMemberArgs].
 */
@PulumiTagMarker
public class GcpOrganizationalDataMemberArgsBuilder internal constructor() {
    private var managementProjectNumber: Output<String>? = null

    private var organizationMembershipType: Output<String>? = null

    private var parentHierarchyId: Output<String>? = null

    /**
     * @param value The GCP management project number from organizational onboarding
     */
    @JvmName("okawuwtrxxlsyomw")
    public suspend fun managementProjectNumber(`value`: Output<String>) {
        this.managementProjectNumber = value
    }

    /**
     * @param value The multi cloud account's membership type in the organization
     * Expected value is 'Member'.
     */
    @JvmName("mxtbhmqdtawdxxsk")
    public suspend fun organizationMembershipType(`value`: Output<String>) {
        this.organizationMembershipType = value
    }

    /**
     * @param value If the multi cloud account is not of membership type organization, this will be the ID of the project's parent
     */
    @JvmName("bwkytawyrhkhqjcv")
    public suspend fun parentHierarchyId(`value`: Output<String>) {
        this.parentHierarchyId = value
    }

    /**
     * @param value The GCP management project number from organizational onboarding
     */
    @JvmName("wassfbvahuygfwod")
    public suspend fun managementProjectNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementProjectNumber = mapped
    }

    /**
     * @param value The multi cloud account's membership type in the organization
     * Expected value is 'Member'.
     */
    @JvmName("ngckwmydiuohixho")
    public suspend fun organizationMembershipType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.organizationMembershipType = mapped
    }

    /**
     * @param value If the multi cloud account is not of membership type organization, this will be the ID of the project's parent
     */
    @JvmName("qqxvijibefqxtotf")
    public suspend fun parentHierarchyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentHierarchyId = mapped
    }

    internal fun build(): GcpOrganizationalDataMemberArgs = GcpOrganizationalDataMemberArgs(
        managementProjectNumber = managementProjectNumber,
        organizationMembershipType = organizationMembershipType ?: throw
            PulumiNullFieldException("organizationMembershipType"),
        parentHierarchyId = parentHierarchyId,
    )
}
