@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetAdaptiveApplicationControlPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ascLocation The location where ASC stores the data of the subscription. can be retrieved from Get locations
 * @property groupName Name of an application control machine group
 */
public data class GetAdaptiveApplicationControlPlainArgs(
    public val ascLocation: String,
    public val groupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetAdaptiveApplicationControlPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.GetAdaptiveApplicationControlPlainArgs =
        com.pulumi.azurenative.security.inputs.GetAdaptiveApplicationControlPlainArgs.builder()
            .ascLocation(ascLocation.let({ args0 -> args0 }))
            .groupName(groupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAdaptiveApplicationControlPlainArgs].
 */
@PulumiTagMarker
public class GetAdaptiveApplicationControlPlainArgsBuilder internal constructor() {
    private var ascLocation: String? = null

    private var groupName: String? = null

    /**
     * @param value The location where ASC stores the data of the subscription. can be retrieved from Get locations
     */
    @JvmName("piekseagmlgjftqc")
    public suspend fun ascLocation(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ascLocation = mapped
    }

    /**
     * @param value Name of an application control machine group
     */
    @JvmName("wyvovewngjetqbfj")
    public suspend fun groupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groupName = mapped
    }

    internal fun build(): GetAdaptiveApplicationControlPlainArgs =
        GetAdaptiveApplicationControlPlainArgs(
            ascLocation = ascLocation ?: throw PulumiNullFieldException("ascLocation"),
            groupName = groupName ?: throw PulumiNullFieldException("groupName"),
        )
}
