@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetConnectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectorName Name of the cloud account connector
 */
public data class GetConnectorPlainArgs(
    public val connectorName: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetConnectorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GetConnectorPlainArgs =
        com.pulumi.azurenative.security.inputs.GetConnectorPlainArgs.builder()
            .connectorName(connectorName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectorPlainArgs].
 */
@PulumiTagMarker
public class GetConnectorPlainArgsBuilder internal constructor() {
    private var connectorName: String? = null

    /**
     * @param value Name of the cloud account connector
     */
    @JvmName("sppfhgiyjaugjowj")
    public suspend fun connectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectorName = mapped
    }

    internal fun build(): GetConnectorPlainArgs = GetConnectorPlainArgs(
        connectorName = connectorName ?: throw PulumiNullFieldException("connectorName"),
    )
}
