@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetCustomEntityStoreAssignmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property customEntityStoreAssignmentName Name of the custom entity store assignment. Generated name is GUID.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class GetCustomEntityStoreAssignmentPlainArgs(
    public val customEntityStoreAssignmentName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetCustomEntityStoreAssignmentPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.GetCustomEntityStoreAssignmentPlainArgs =
        com.pulumi.azurenative.security.inputs.GetCustomEntityStoreAssignmentPlainArgs.builder()
            .customEntityStoreAssignmentName(customEntityStoreAssignmentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCustomEntityStoreAssignmentPlainArgs].
 */
@PulumiTagMarker
public class GetCustomEntityStoreAssignmentPlainArgsBuilder internal constructor() {
    private var customEntityStoreAssignmentName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the custom entity store assignment. Generated name is GUID.
     */
    @JvmName("jqunvesixnqmoowu")
    public suspend fun customEntityStoreAssignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.customEntityStoreAssignmentName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("hduvdiujlsthnjly")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCustomEntityStoreAssignmentPlainArgs =
        GetCustomEntityStoreAssignmentPlainArgs(
            customEntityStoreAssignmentName = customEntityStoreAssignmentName ?: throw
                PulumiNullFieldException("customEntityStoreAssignmentName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
