@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetDeviceSecurityGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deviceSecurityGroupName The name of the device security group. Note that the name of the device security group is case insensitive.
 * @property resourceId The identifier of the resource.
 */
public data class GetDeviceSecurityGroupPlainArgs(
    public val deviceSecurityGroupName: String,
    public val resourceId: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetDeviceSecurityGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GetDeviceSecurityGroupPlainArgs =
        com.pulumi.azurenative.security.inputs.GetDeviceSecurityGroupPlainArgs.builder()
            .deviceSecurityGroupName(deviceSecurityGroupName.let({ args0 -> args0 }))
            .resourceId(resourceId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDeviceSecurityGroupPlainArgs].
 */
@PulumiTagMarker
public class GetDeviceSecurityGroupPlainArgsBuilder internal constructor() {
    private var deviceSecurityGroupName: String? = null

    private var resourceId: String? = null

    /**
     * @param value The name of the device security group. Note that the name of the device security group is case insensitive.
     */
    @JvmName("moeemwehflypbjmw")
    public suspend fun deviceSecurityGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deviceSecurityGroupName = mapped
    }

    /**
     * @param value The identifier of the resource.
     */
    @JvmName("fhabnxyuyfgfibiw")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceId = mapped
    }

    internal fun build(): GetDeviceSecurityGroupPlainArgs = GetDeviceSecurityGroupPlainArgs(
        deviceSecurityGroupName = deviceSecurityGroupName ?: throw
            PulumiNullFieldException("deviceSecurityGroupName"),
        resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
    )
}
