@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetGovernanceAssignmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property assessmentName The Assessment Key - A unique key for the assessment type
 * @property assignmentKey The governance assignment key - the assessment key of the required governance assignment
 * @property scope The scope of the Governance assignments. Valid scopes are: subscription (format: 'subscriptions/{subscriptionId}'), or security connector (format: 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'
 */
public data class GetGovernanceAssignmentPlainArgs(
    public val assessmentName: String,
    public val assignmentKey: String,
    public val scope: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetGovernanceAssignmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GetGovernanceAssignmentPlainArgs =
        com.pulumi.azurenative.security.inputs.GetGovernanceAssignmentPlainArgs.builder()
            .assessmentName(assessmentName.let({ args0 -> args0 }))
            .assignmentKey(assignmentKey.let({ args0 -> args0 }))
            .scope(scope.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGovernanceAssignmentPlainArgs].
 */
@PulumiTagMarker
public class GetGovernanceAssignmentPlainArgsBuilder internal constructor() {
    private var assessmentName: String? = null

    private var assignmentKey: String? = null

    private var scope: String? = null

    /**
     * @param value The Assessment Key - A unique key for the assessment type
     */
    @JvmName("ypjqmlrjljnapunm")
    public suspend fun assessmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.assessmentName = mapped
    }

    /**
     * @param value The governance assignment key - the assessment key of the required governance assignment
     */
    @JvmName("oaqadinkesmtbewg")
    public suspend fun assignmentKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.assignmentKey = mapped
    }

    /**
     * @param value The scope of the Governance assignments. Valid scopes are: subscription (format: 'subscriptions/{subscriptionId}'), or security connector (format: 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'
     */
    @JvmName("ghrhwyccfunggmgm")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scope = mapped
    }

    internal fun build(): GetGovernanceAssignmentPlainArgs = GetGovernanceAssignmentPlainArgs(
        assessmentName = assessmentName ?: throw PulumiNullFieldException("assessmentName"),
        assignmentKey = assignmentKey ?: throw PulumiNullFieldException("assignmentKey"),
        scope = scope ?: throw PulumiNullFieldException("scope"),
    )
}
