@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetServerVulnerabilityAssessmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property resourceName Name of the resource.
 * @property resourceNamespace The Namespace of the resource.
 * @property resourceType The type of the resource.
 * @property serverVulnerabilityAssessment ServerVulnerabilityAssessment status. only a 'default' value is supported.
 */
public data class GetServerVulnerabilityAssessmentPlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
    public val resourceNamespace: String,
    public val resourceType: String,
    public val serverVulnerabilityAssessment: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetServerVulnerabilityAssessmentPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.GetServerVulnerabilityAssessmentPlainArgs =
        com.pulumi.azurenative.security.inputs.GetServerVulnerabilityAssessmentPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 }))
            .resourceNamespace(resourceNamespace.let({ args0 -> args0 }))
            .resourceType(resourceType.let({ args0 -> args0 }))
            .serverVulnerabilityAssessment(serverVulnerabilityAssessment.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerVulnerabilityAssessmentPlainArgs].
 */
@PulumiTagMarker
public class GetServerVulnerabilityAssessmentPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    private var resourceNamespace: String? = null

    private var resourceType: String? = null

    private var serverVulnerabilityAssessment: String? = null

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("gvhwacwmfqetppkk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the resource.
     */
    @JvmName("pknbgtklbouxorjt")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    /**
     * @param value The Namespace of the resource.
     */
    @JvmName("kmhdaidatdchavat")
    public suspend fun resourceNamespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceNamespace = mapped
    }

    /**
     * @param value The type of the resource.
     */
    @JvmName("elxgtfuketwncqwq")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceType = mapped
    }

    /**
     * @param value ServerVulnerabilityAssessment status. only a 'default' value is supported.
     */
    @JvmName("vbqkytubdoprapsc")
    public suspend fun serverVulnerabilityAssessment(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverVulnerabilityAssessment = mapped
    }

    internal fun build(): GetServerVulnerabilityAssessmentPlainArgs =
        GetServerVulnerabilityAssessmentPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
            resourceNamespace = resourceNamespace ?: throw PulumiNullFieldException("resourceNamespace"),
            resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
            serverVulnerabilityAssessment = serverVulnerabilityAssessment ?: throw
                PulumiNullFieldException("serverVulnerabilityAssessment"),
        )
}
