@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetWorkspaceSettingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property workspaceSettingName Name of the security setting
 */
public data class GetWorkspaceSettingPlainArgs(
    public val workspaceSettingName: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetWorkspaceSettingPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GetWorkspaceSettingPlainArgs =
        com.pulumi.azurenative.security.inputs.GetWorkspaceSettingPlainArgs.builder()
            .workspaceSettingName(workspaceSettingName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkspaceSettingPlainArgs].
 */
@PulumiTagMarker
public class GetWorkspaceSettingPlainArgsBuilder internal constructor() {
    private var workspaceSettingName: String? = null

    /**
     * @param value Name of the security setting
     */
    @JvmName("vilwdeuklcpjlufk")
    public suspend fun workspaceSettingName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceSettingName = mapped
    }

    internal fun build(): GetWorkspaceSettingPlainArgs = GetWorkspaceSettingPlainArgs(
        workspaceSettingName = workspaceSettingName ?: throw
            PulumiNullFieldException("workspaceSettingName"),
    )
}
