@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GovernanceEmailNotificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The governance email weekly notification configuration.
 * @property disableManagerEmailNotification Exclude manager from weekly email notification.
 * @property disableOwnerEmailNotification Exclude  owner from weekly email notification.
 */
public data class GovernanceEmailNotificationArgs(
    public val disableManagerEmailNotification: Output<Boolean>? = null,
    public val disableOwnerEmailNotification: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GovernanceEmailNotificationArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GovernanceEmailNotificationArgs =
        com.pulumi.azurenative.security.inputs.GovernanceEmailNotificationArgs.builder()
            .disableManagerEmailNotification(disableManagerEmailNotification?.applyValue({ args0 -> args0 }))
            .disableOwnerEmailNotification(
                disableOwnerEmailNotification?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [GovernanceEmailNotificationArgs].
 */
@PulumiTagMarker
public class GovernanceEmailNotificationArgsBuilder internal constructor() {
    private var disableManagerEmailNotification: Output<Boolean>? = null

    private var disableOwnerEmailNotification: Output<Boolean>? = null

    /**
     * @param value Exclude manager from weekly email notification.
     */
    @JvmName("afvetgpwbyhgrjnb")
    public suspend fun disableManagerEmailNotification(`value`: Output<Boolean>) {
        this.disableManagerEmailNotification = value
    }

    /**
     * @param value Exclude  owner from weekly email notification.
     */
    @JvmName("gawicoosvcwiwbqa")
    public suspend fun disableOwnerEmailNotification(`value`: Output<Boolean>) {
        this.disableOwnerEmailNotification = value
    }

    /**
     * @param value Exclude manager from weekly email notification.
     */
    @JvmName("bpbvpjxvfefxqwhx")
    public suspend fun disableManagerEmailNotification(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableManagerEmailNotification = mapped
    }

    /**
     * @param value Exclude  owner from weekly email notification.
     */
    @JvmName("lxsdsvjxevolwewk")
    public suspend fun disableOwnerEmailNotification(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableOwnerEmailNotification = mapped
    }

    internal fun build(): GovernanceEmailNotificationArgs = GovernanceEmailNotificationArgs(
        disableManagerEmailNotification = disableManagerEmailNotification,
        disableOwnerEmailNotification = disableOwnerEmailNotification,
    )
}
