@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.JitNetworkAccessRequestPortArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.Status
import com.pulumi.azurenative.security.kotlin.enums.StatusReason
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowedSourceAddressPrefix Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
 * @property allowedSourceAddressPrefixes Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
 * @property endTimeUtc The date & time at which the request ends in UTC
 * @property mappedPort The port which is mapped to this port's `number` in the Azure Firewall, if applicable
 * @property number
 * @property status The status of the port
 * @property statusReason A description of why the `status` has its value
 */
public data class JitNetworkAccessRequestPortArgs(
    public val allowedSourceAddressPrefix: Output<String>? = null,
    public val allowedSourceAddressPrefixes: Output<List<String>>? = null,
    public val endTimeUtc: Output<String>,
    public val mappedPort: Output<Int>? = null,
    public val number: Output<Int>,
    public val status: Output<Either<String, Status>>,
    public val statusReason: Output<Either<String, StatusReason>>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.JitNetworkAccessRequestPortArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.JitNetworkAccessRequestPortArgs =
        com.pulumi.azurenative.security.inputs.JitNetworkAccessRequestPortArgs.builder()
            .allowedSourceAddressPrefix(allowedSourceAddressPrefix?.applyValue({ args0 -> args0 }))
            .allowedSourceAddressPrefixes(
                allowedSourceAddressPrefixes?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .endTimeUtc(endTimeUtc.applyValue({ args0 -> args0 }))
            .mappedPort(mappedPort?.applyValue({ args0 -> args0 }))
            .number(number.applyValue({ args0 -> args0 }))
            .status(
                status.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .statusReason(
                statusReason.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [JitNetworkAccessRequestPortArgs].
 */
@PulumiTagMarker
public class JitNetworkAccessRequestPortArgsBuilder internal constructor() {
    private var allowedSourceAddressPrefix: Output<String>? = null

    private var allowedSourceAddressPrefixes: Output<List<String>>? = null

    private var endTimeUtc: Output<String>? = null

    private var mappedPort: Output<Int>? = null

    private var number: Output<Int>? = null

    private var status: Output<Either<String, Status>>? = null

    private var statusReason: Output<Either<String, StatusReason>>? = null

    /**
     * @param value Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
     */
    @JvmName("ysfdblrrvdqengvy")
    public suspend fun allowedSourceAddressPrefix(`value`: Output<String>) {
        this.allowedSourceAddressPrefix = value
    }

    /**
     * @param value Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
     */
    @JvmName("dbswsamlfrsfvoub")
    public suspend fun allowedSourceAddressPrefixes(`value`: Output<List<String>>) {
        this.allowedSourceAddressPrefixes = value
    }

    @JvmName("wugoydhrlfaywnjb")
    public suspend fun allowedSourceAddressPrefixes(vararg values: Output<String>) {
        this.allowedSourceAddressPrefixes = Output.all(values.asList())
    }

    /**
     * @param values Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
     */
    @JvmName("irypwblwotbeqvhg")
    public suspend fun allowedSourceAddressPrefixes(values: List<Output<String>>) {
        this.allowedSourceAddressPrefixes = Output.all(values)
    }

    /**
     * @param value The date & time at which the request ends in UTC
     */
    @JvmName("yakxauyuvbvjeaou")
    public suspend fun endTimeUtc(`value`: Output<String>) {
        this.endTimeUtc = value
    }

    /**
     * @param value The port which is mapped to this port's `number` in the Azure Firewall, if applicable
     */
    @JvmName("wrutwfuqprxonbbf")
    public suspend fun mappedPort(`value`: Output<Int>) {
        this.mappedPort = value
    }

    /**
     * @param value
     */
    @JvmName("lnesiolvpnkkikem")
    public suspend fun number(`value`: Output<Int>) {
        this.number = value
    }

    /**
     * @param value The status of the port
     */
    @JvmName("lphpsnumvjhducqu")
    public suspend fun status(`value`: Output<Either<String, Status>>) {
        this.status = value
    }

    /**
     * @param value A description of why the `status` has its value
     */
    @JvmName("lquxofbudpvixtnc")
    public suspend fun statusReason(`value`: Output<Either<String, StatusReason>>) {
        this.statusReason = value
    }

    /**
     * @param value Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
     */
    @JvmName("xftmqopdbnxhkntj")
    public suspend fun allowedSourceAddressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedSourceAddressPrefix = mapped
    }

    /**
     * @param value Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
     */
    @JvmName("vbrkoepjhswmmxfq")
    public suspend fun allowedSourceAddressPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedSourceAddressPrefixes = mapped
    }

    /**
     * @param values Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
     */
    @JvmName("lduqnaiwgnxqhjvh")
    public suspend fun allowedSourceAddressPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedSourceAddressPrefixes = mapped
    }

    /**
     * @param value The date & time at which the request ends in UTC
     */
    @JvmName("anlptjeyewlxmfdk")
    public suspend fun endTimeUtc(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endTimeUtc = mapped
    }

    /**
     * @param value The port which is mapped to this port's `number` in the Azure Firewall, if applicable
     */
    @JvmName("rxoyjglcmsekfdyk")
    public suspend fun mappedPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mappedPort = mapped
    }

    /**
     * @param value
     */
    @JvmName("kocvljthhypiyaxc")
    public suspend fun number(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.number = mapped
    }

    /**
     * @param value The status of the port
     */
    @JvmName("ngapdmsougbrjmni")
    public suspend fun status(`value`: Either<String, Status>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of the port
     */
    @JvmName("rplvbyxocxdeppld")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Status>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of the port
     */
    @JvmName("oybyibuhwshnkqko")
    public fun status(`value`: Status) {
        val toBeMapped = Either.ofRight<String, Status>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value A description of why the `status` has its value
     */
    @JvmName("mhacnabuvcygyjhu")
    public suspend fun statusReason(`value`: Either<String, StatusReason>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statusReason = mapped
    }

    /**
     * @param value A description of why the `status` has its value
     */
    @JvmName("ohjsjidaqxdstxwl")
    public fun statusReason(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StatusReason>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statusReason = mapped
    }

    /**
     * @param value A description of why the `status` has its value
     */
    @JvmName("vwwmsyhmmbqetses")
    public fun statusReason(`value`: StatusReason) {
        val toBeMapped = Either.ofRight<String, StatusReason>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statusReason = mapped
    }

    internal fun build(): JitNetworkAccessRequestPortArgs = JitNetworkAccessRequestPortArgs(
        allowedSourceAddressPrefix = allowedSourceAddressPrefix,
        allowedSourceAddressPrefixes = allowedSourceAddressPrefixes,
        endTimeUtc = endTimeUtc ?: throw PulumiNullFieldException("endTimeUtc"),
        mappedPort = mappedPort,
        number = number ?: throw PulumiNullFieldException("number"),
        status = status ?: throw PulumiNullFieldException("status"),
        statusReason = statusReason ?: throw PulumiNullFieldException("statusReason"),
    )
}
