@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.ListGitLabSubgroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property groupFQName The GitLab group fully-qualified name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property securityConnectorName The security connector name.
 */
public data class ListGitLabSubgroupPlainArgs(
    public val groupFQName: String,
    public val resourceGroupName: String,
    public val securityConnectorName: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.ListGitLabSubgroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.ListGitLabSubgroupPlainArgs =
        com.pulumi.azurenative.security.inputs.ListGitLabSubgroupPlainArgs.builder()
            .groupFQName(groupFQName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .securityConnectorName(securityConnectorName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListGitLabSubgroupPlainArgs].
 */
@PulumiTagMarker
public class ListGitLabSubgroupPlainArgsBuilder internal constructor() {
    private var groupFQName: String? = null

    private var resourceGroupName: String? = null

    private var securityConnectorName: String? = null

    /**
     * @param value The GitLab group fully-qualified name.
     */
    @JvmName("oldurpivwayubolb")
    public suspend fun groupFQName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groupFQName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gcleajgmcgicopdl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The security connector name.
     */
    @JvmName("oslhmfukfogwmgge")
    public suspend fun securityConnectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.securityConnectorName = mapped
    }

    internal fun build(): ListGitLabSubgroupPlainArgs = ListGitLabSubgroupPlainArgs(
        groupFQName = groupFQName ?: throw PulumiNullFieldException("groupFQName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        securityConnectorName = securityConnectorName ?: throw
            PulumiNullFieldException("securityConnectorName"),
    )
}
