@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.ProxyServerPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * For a non-Azure machine that is not connected directly to the internet, specify a proxy server that the non-Azure machine can use.
 * @property ip Proxy server IP
 * @property port Proxy server port
 */
public data class ProxyServerPropertiesArgs(
    public val ip: Output<String>? = null,
    public val port: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.ProxyServerPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.ProxyServerPropertiesArgs =
        com.pulumi.azurenative.security.inputs.ProxyServerPropertiesArgs.builder()
            .ip(ip?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProxyServerPropertiesArgs].
 */
@PulumiTagMarker
public class ProxyServerPropertiesArgsBuilder internal constructor() {
    private var ip: Output<String>? = null

    private var port: Output<String>? = null

    /**
     * @param value Proxy server IP
     */
    @JvmName("qoamsdbiyhjbngbn")
    public suspend fun ip(`value`: Output<String>) {
        this.ip = value
    }

    /**
     * @param value Proxy server port
     */
    @JvmName("qtroohiuhdwlintp")
    public suspend fun port(`value`: Output<String>) {
        this.port = value
    }

    /**
     * @param value Proxy server IP
     */
    @JvmName("wsutglwygwbkkyec")
    public suspend fun ip(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ip = mapped
    }

    /**
     * @param value Proxy server port
     */
    @JvmName("oslnyicibepwqaak")
    public suspend fun port(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): ProxyServerPropertiesArgs = ProxyServerPropertiesArgs(
        ip = ip,
        port = port,
    )
}
