@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.ServicePrincipalPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Details of the service principal.
 * @property applicationId Application ID of service principal.
 * @property secret A secret string that the application uses to prove its identity, also can be referred to as application password (write only).
 */
public data class ServicePrincipalPropertiesArgs(
    public val applicationId: Output<String>? = null,
    public val secret: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.ServicePrincipalPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.ServicePrincipalPropertiesArgs =
        com.pulumi.azurenative.security.inputs.ServicePrincipalPropertiesArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .secret(secret?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServicePrincipalPropertiesArgs].
 */
@PulumiTagMarker
public class ServicePrincipalPropertiesArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var secret: Output<String>? = null

    /**
     * @param value Application ID of service principal.
     */
    @JvmName("suyurrltqbaoqvsl")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value A secret string that the application uses to prove its identity, also can be referred to as application password (write only).
     */
    @JvmName("urdvicchhogsdinp")
    public suspend fun secret(`value`: Output<String>) {
        this.secret = value
    }

    /**
     * @param value Application ID of service principal.
     */
    @JvmName("vraqufbgwvdcgxdq")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value A secret string that the application uses to prove its identity, also can be referred to as application password (write only).
     */
    @JvmName("yoqnpadrpvuvwdkn")
    public suspend fun secret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secret = mapped
    }

    internal fun build(): ServicePrincipalPropertiesArgs = ServicePrincipalPropertiesArgs(
        applicationId = applicationId,
        secret = secret,
    )
}
