@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.UserDefinedResourcesPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of the IoT Security solution's user defined resources.
 * @property query Azure Resource Graph query which represents the security solution's user defined resources. Required to start with "where type != "Microsoft.Devices/IotHubs""
 * @property querySubscriptions List of Azure subscription ids on which the user defined resources query should be executed.
 */
public data class UserDefinedResourcesPropertiesArgs(
    public val query: Output<String>,
    public val querySubscriptions: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.UserDefinedResourcesPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.UserDefinedResourcesPropertiesArgs =
        com.pulumi.azurenative.security.inputs.UserDefinedResourcesPropertiesArgs.builder()
            .query(query.applyValue({ args0 -> args0 }))
            .querySubscriptions(querySubscriptions.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [UserDefinedResourcesPropertiesArgs].
 */
@PulumiTagMarker
public class UserDefinedResourcesPropertiesArgsBuilder internal constructor() {
    private var query: Output<String>? = null

    private var querySubscriptions: Output<List<String>>? = null

    /**
     * @param value Azure Resource Graph query which represents the security solution's user defined resources. Required to start with "where type != "Microsoft.Devices/IotHubs""
     */
    @JvmName("dofshdrhebbypxww")
    public suspend fun query(`value`: Output<String>) {
        this.query = value
    }

    /**
     * @param value List of Azure subscription ids on which the user defined resources query should be executed.
     */
    @JvmName("sevelhbiddtncexy")
    public suspend fun querySubscriptions(`value`: Output<List<String>>) {
        this.querySubscriptions = value
    }

    @JvmName("tjvupbymkjrbwwda")
    public suspend fun querySubscriptions(vararg values: Output<String>) {
        this.querySubscriptions = Output.all(values.asList())
    }

    /**
     * @param values List of Azure subscription ids on which the user defined resources query should be executed.
     */
    @JvmName("uxprpekyvqiwcdjg")
    public suspend fun querySubscriptions(values: List<Output<String>>) {
        this.querySubscriptions = Output.all(values)
    }

    /**
     * @param value Azure Resource Graph query which represents the security solution's user defined resources. Required to start with "where type != "Microsoft.Devices/IotHubs""
     */
    @JvmName("lmueawcbuhooeceq")
    public suspend fun query(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.query = mapped
    }

    /**
     * @param value List of Azure subscription ids on which the user defined resources query should be executed.
     */
    @JvmName("uxwvvdghohovguyb")
    public suspend fun querySubscriptions(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.querySubscriptions = mapped
    }

    /**
     * @param values List of Azure subscription ids on which the user defined resources query should be executed.
     */
    @JvmName("mowaxofxjocvaoxn")
    public suspend fun querySubscriptions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.querySubscriptions = mapped
    }

    internal fun build(): UserDefinedResourcesPropertiesArgs = UserDefinedResourcesPropertiesArgs(
        query = query ?: throw PulumiNullFieldException("query"),
        querySubscriptions = querySubscriptions ?: throw PulumiNullFieldException("querySubscriptions"),
    )
}
