@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Configuration payload for PR Annotations.
 * @property branchConfiguration Repository branch configuration for PR Annotations.
 * @property categoryConfigurations Gets or sets list of categories and severity levels.
 * @property inheritFromParentState Update Settings.
 * Enabled - Resource should inherit configurations from parent.
 * Disabled - Resource should not inherit configurations from parent.
 * @property state ActionableRemediation Setting.
 * None - the setting was never set.
 * Enabled - ActionableRemediation is enabled.
 * Disabled - ActionableRemediation is disabled.
 */
public data class ActionableRemediationResponse(
    public val branchConfiguration: TargetBranchConfigurationResponse? = null,
    public val categoryConfigurations: List<CategoryConfigurationResponse>? = null,
    public val inheritFromParentState: String? = null,
    public val state: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.ActionableRemediationResponse):
            ActionableRemediationResponse = ActionableRemediationResponse(
            branchConfiguration = javaType.branchConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.TargetBranchConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            categoryConfigurations = javaType.categoryConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.CategoryConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            inheritFromParentState = javaType.inheritFromParentState().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
