@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Log Analytics Workspace to which event data will be exported. Security alerts data will reside in the 'SecurityAlert' table and the assessments data will reside in the 'SecurityRecommendation' table (under the 'Security'/'SecurityCenterFree' solutions). Note that in order to view the data in the workspace, the Security Center Log Analytics free/standard solution needs to be enabled on that workspace. To learn more about Microsoft Defender for Cloud continuous export capabilities, visit https://aka.ms/ASCExportLearnMore
 * @property actionType The type of the action that will be triggered by the Automation
 * Expected value is 'Workspace'.
 * @property workspaceResourceId The fully qualified Log Analytics Workspace Azure Resource ID.
 */
public data class AutomationActionWorkspaceResponse(
    public val actionType: String,
    public val workspaceResourceId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.AutomationActionWorkspaceResponse):
            AutomationActionWorkspaceResponse = AutomationActionWorkspaceResponse(
            actionType = javaType.actionType(),
            workspaceResourceId = javaType.workspaceResourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
