@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * AWS cloud account connector based assume role, the role enables delegating access to your AWS resources. The role is composed of role Amazon Resource Name (ARN) and external ID. For more details, refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user.html">Creating a Role to Delegate Permissions to an IAM User (write only)</a>
 * @property accountId The ID of the cloud account
 * @property authenticationProvisioningState State of the multi-cloud connector
 * @property authenticationType Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials.
 * Expected value is 'awsAssumeRole'.
 * @property awsAssumeRoleArn Assumed role ID is an identifier that you can use to create temporary security credentials.
 * @property awsExternalId A unique identifier that is required when you assume a role in another account.
 * @property grantedPermissions The permissions detected in the cloud account.
 */
public data class AwAssumeRoleAuthenticationDetailsPropertiesResponse(
    public val accountId: String,
    public val authenticationProvisioningState: String,
    public val authenticationType: String,
    public val awsAssumeRoleArn: String,
    public val awsExternalId: String,
    public val grantedPermissions: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.AwAssumeRoleAuthenticationDetailsPropertiesResponse):
            AwAssumeRoleAuthenticationDetailsPropertiesResponse =
            AwAssumeRoleAuthenticationDetailsPropertiesResponse(
                accountId = javaType.accountId(),
                authenticationProvisioningState = javaType.authenticationProvisioningState(),
                authenticationType = javaType.authenticationType(),
                awsAssumeRoleArn = javaType.awsAssumeRoleArn(),
                awsExternalId = javaType.awsExternalId(),
                grantedPermissions = javaType.grantedPermissions().map({ args0 -> args0 }),
            )
    }
}
