@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The AWS organization data for the member account
 * @property organizationMembershipType The multi cloud account's membership type in the organization
 * Expected value is 'Member'.
 * @property parentHierarchyId If the multi cloud account is not of membership type organization, this will be the ID of the account's parent
 */
public data class AwsOrganizationalDataMemberResponse(
    public val organizationMembershipType: String,
    public val parentHierarchyId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.AwsOrganizationalDataMemberResponse):
            AwsOrganizationalDataMemberResponse = AwsOrganizationalDataMemberResponse(
            organizationMembershipType = javaType.organizationMembershipType(),
            parentHierarchyId = javaType.parentHierarchyId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
