@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The CSPM P1 for AWS offering
 * @property dataSensitivityDiscovery The Microsoft Defender Data Sensitivity discovery configuration
 * @property databasesDspm The databases DSPM configuration
 * @property description The offering description.
 * @property offeringType The type of the security offering.
 * Expected value is 'DefenderCspmAws'.
 * @property vmScanners The Microsoft Defender for Server VM scanning configuration
 */
public data class DefenderCspmAwsOfferingResponse(
    public val dataSensitivityDiscovery: DefenderCspmAwsOfferingResponseDataSensitivityDiscovery? =
        null,
    public val databasesDspm: DefenderCspmAwsOfferingResponseDatabasesDspm? = null,
    public val description: String,
    public val offeringType: String,
    public val vmScanners: DefenderCspmAwsOfferingResponseVmScanners? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DefenderCspmAwsOfferingResponse):
            DefenderCspmAwsOfferingResponse = DefenderCspmAwsOfferingResponse(
            dataSensitivityDiscovery = javaType.dataSensitivityDiscovery().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderCspmAwsOfferingResponseDataSensitivityDiscovery.Companion.toKotlin(args0)
                })
            }).orElse(null),
            databasesDspm = javaType.databasesDspm().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderCspmAwsOfferingResponseDatabasesDspm.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description(),
            offeringType = javaType.offeringType(),
            vmScanners = javaType.vmScanners().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderCspmAwsOfferingResponseVmScanners.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
