@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Defender for Databases AWS offering
 * @property arcAutoProvisioning The ARC autoprovisioning configuration
 * @property databasesDspm The databases data security posture management (DSPM) configuration
 * @property description The offering description.
 * @property offeringType The type of the security offering.
 * Expected value is 'DefenderForDatabasesAws'.
 * @property rds The RDS configuration
 */
public data class DefenderFoDatabasesAwsOfferingResponse(
    public val arcAutoProvisioning: DefenderFoDatabasesAwsOfferingResponseArcAutoProvisioning? = null,
    public val databasesDspm: DefenderFoDatabasesAwsOfferingResponseDatabasesDspm? = null,
    public val description: String,
    public val offeringType: String,
    public val rds: DefenderFoDatabasesAwsOfferingResponseRds? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DefenderFoDatabasesAwsOfferingResponse):
            DefenderFoDatabasesAwsOfferingResponse = DefenderFoDatabasesAwsOfferingResponse(
            arcAutoProvisioning = javaType.arcAutoProvisioning().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderFoDatabasesAwsOfferingResponseArcAutoProvisioning.Companion.toKotlin(args0)
                })
            }).orElse(null),
            databasesDspm = javaType.databasesDspm().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderFoDatabasesAwsOfferingResponseDatabasesDspm.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description(),
            offeringType = javaType.offeringType(),
            rds = javaType.rds().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderFoDatabasesAwsOfferingResponseRds.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
