@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The databases data security posture management (DSPM) configuration
 * @property cloudRoleArn The cloud role ARN in AWS for this feature
 * @property enabled Is databases data security posture management (DSPM) protection enabled
 */
public data class DefenderFoDatabasesAwsOfferingResponseDatabasesDspm(
    public val cloudRoleArn: String? = null,
    public val enabled: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DefenderFoDatabasesAwsOfferingResponseDatabasesDspm):
            DefenderFoDatabasesAwsOfferingResponseDatabasesDspm =
            DefenderFoDatabasesAwsOfferingResponseDatabasesDspm(
                cloudRoleArn = javaType.cloudRoleArn().map({ args0 -> args0 }).orElse(null),
                enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            )
    }
}
